/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.bpm;

import java.util.Map;
import javax.resource.spi.work.Work;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.bpm.ProcessConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public class ProcessMessageReceiver
extends AbstractMessageReceiver {
    private ProcessConnector connector = null;

    public ProcessMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws CreateException {
        super(connector, component, (UMOImmutableEndpoint)endpoint);
        this.connector = (ProcessConnector)connector;
    }

    public UMOMessage generateSynchronousEvent(String endpoint, Object payload, Map messageProperties) throws UMOException {
        this.logger.debug((Object)("Executing process is sending an event (synchronously) to Mule endpoint = " + endpoint));
        UMOMessage response = this.generateEvent(endpoint, payload, messageProperties, true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Synchronous response is " + (response != null ? response.getPayload() : null)));
        }
        return response;
    }

    public void generateAsynchronousEvent(String endpoint, Object payload, Map messageProperties) throws UMOException {
        this.logger.debug((Object)("Executing process is dispatching an event (asynchronously) to Mule endpoint = " + endpoint));
        try {
            this.getWorkManager().scheduleWork((Work)new Worker(endpoint, payload, messageProperties));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected UMOMessage generateEvent(String endpoint, Object payload, Map messageProperties, boolean synchronous) throws UMOException {
        Object message = payload instanceof UMOMessage ? (UMOMessage)payload : new MuleMessage((Object)this.connector.getMessageAdapter(payload));
        message.addProperties(messageProperties);
        if (this.connector.isAllowGlobalDispatcher()) {
            if (synchronous) {
                return this.connector.getMuleClient().send(endpoint, message);
            }
            this.connector.getMuleClient().dispatch(endpoint, message);
            return null;
        }
        message.setStringProperty("endpoint", endpoint);
        return this.routeMessage((UMOMessage)message, synchronous);
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    protected void doDispose() {
    }

    private class Worker
    implements Work {
        private String endpoint;
        private Object payload;
        private Map messageProperties;

        public Worker(String endpoint, Object payload, Map messageProperties) {
            this.endpoint = endpoint;
            this.payload = payload;
            this.messageProperties = messageProperties;
        }

        public void run() {
            try {
                ProcessMessageReceiver.this.generateEvent(this.endpoint, this.payload, this.messageProperties, false);
            }
            catch (Exception e) {
                ProcessMessageReceiver.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }
    }
}

