/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ejb;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.ejb.EJBObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.providers.ejb.EjbAble;
import org.mule.providers.ejb.EjbConnector;
import org.mule.providers.ejb.EjbMessageReceiver;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.ClassUtils;

public class EjbConnectorUtil {
    protected static transient Log logger = LogFactory.getLog((Class)EjbConnectorUtil.class);

    private EjbConnectorUtil() {
    }

    public static EJBObject getRemoteObject(UMOEndpoint endpoint, EjbConnector connector) throws RemoteException, UnknownHostException {
        EJBObject remoteObj = null;
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        int port = endpointUri.getPort();
        if (port < 1) {
            port = 1099;
        }
        InetAddress inetAddress = InetAddress.getByName(endpointUri.getHost());
        String serviceName = endpointUri.getPath();
        try {
            Object ref = connector.getJndiContext(inetAddress.getHostAddress() + ":" + port).lookup(serviceName);
            Method method = ClassUtils.getMethod((String)"create", null, ref.getClass());
            remoteObj = (EJBObject)method.invoke(ref, ClassUtils.NO_ARGS);
        }
        catch (Exception e) {
            throw new RemoteException("Remote EJBObject lookup failed for '" + inetAddress.getHostAddress() + ":" + port + serviceName + "'", e);
        }
        return remoteObj;
    }

    public static Method getMethodObject(UMOEndpoint endpoint, EJBObject remoteObject, EjbConnector connector, Class clazz) throws InitialisationException, NoSuchMethodException {
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        String methodName = MapUtils.getString((Map)endpointUri.getParams(), (Object)"method", null);
        if (null == methodName && null == (methodName = (String)endpoint.getProperties().get("method"))) {
            throw new InitialisationException(new Message("ejb", 1), (Object)endpoint);
        }
        Class[] argumentClasses = null;
        if (clazz.equals(EjbMessageReceiver.class)) {
            try {
                EjbAble object = (EjbAble)ClassUtils.instanciateClass((String)connector.getReceiverArgumentClass(), (Object[])ClassUtils.NO_ARGS);
                argumentClasses = object.argumentClasses();
                connector.setEjbAble(object);
            }
            catch (Exception e) {
                throw new InitialisationException(new Message("ejb", 2), (Object)e);
            }
        } else {
            argumentClasses = connector.getArgumentClasses();
        }
        return remoteObject.getClass().getMethod(methodName, argumentClasses);
    }
}

