/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ejb;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import javax.ejb.EJBObject;
import org.apache.commons.collections.MapUtils;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.ejb.EjbConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.ClassUtils;

public class EjbMessageDispatcher
extends AbstractMessageDispatcher {
    private EjbConnector connector;
    protected EJBObject remoteObject;

    public EjbMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (EjbConnector)endpoint.getConnector();
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws IOException, InitialisationException, NotBoundException, NoSuchMethodException, ClassNotFoundException {
        if (this.remoteObject == null) {
            String rmiPolicyPath = this.connector.getSecurityPolicy();
            System.setProperty("java.security.policy", rmiPolicyPath);
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            this.remoteObject = this.getRemoteObject();
        }
    }

    protected void doDisconnect() throws Exception {
        this.remoteObject = null;
    }

    protected EJBObject getRemoteObject() throws RemoteException, UnknownHostException {
        EJBObject remoteObj;
        UMOEndpointURI endpointUri = this.endpoint.getEndpointURI();
        int port = endpointUri.getPort();
        if (port < 1) {
            port = 1099;
        }
        InetAddress inetAddress = InetAddress.getByName(endpointUri.getHost());
        String serviceName = endpointUri.getPath();
        try {
            Object ref = this.connector.getJndiContext(inetAddress.getHostAddress() + ":" + port).lookup(serviceName);
            Method method = ClassUtils.getMethod((String)"create", null, ref.getClass());
            remoteObj = (EJBObject)method.invoke(ref, ClassUtils.NO_ARGS);
        }
        catch (Exception e) {
            throw new RemoteException("Remote EJBObject lookup failed for '" + inetAddress.getHostAddress() + ":" + port + serviceName + "'", e);
        }
        return remoteObj;
    }

    protected Method getMethodObject(UMOEvent event, EJBObject remoteObject) throws UMOException, NoSuchMethodException, ClassNotFoundException {
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        String methodName = MapUtils.getString((Map)endpointUri.getParams(), (Object)"method", null);
        if (null == methodName && null == (methodName = (String)event.getMessage().getProperty("method"))) {
            throw new DispatchException(new Message("ejb", 1), event.getMessage(), event.getEndpoint());
        }
        String arguments = (String)event.getMessage().getProperty("methodArgumentTypes");
        ArrayList methodArgumentTypes = new ArrayList();
        if (null != arguments) {
            String[] split = arguments.split(",");
            for (int i = 0; i < split.length; ++i) {
                methodArgumentTypes.add(ClassUtils.loadClass((String)split[i].trim(), ((Object)((Object)this)).getClass()));
            }
        } else if (event.getTransformedMessage().getClass().isArray()) {
            Object[] args = (Object[])event.getTransformedMessage();
            for (int i = 0; i < args.length; ++i) {
                methodArgumentTypes.add(args[i].getClass());
            }
        } else {
            methodArgumentTypes.add(event.getTransformedMessage().getClass());
        }
        Class[] types = new Class[methodArgumentTypes.size()];
        types = methodArgumentTypes.toArray(types);
        return remoteObject.getClass().getMethod(methodName, types);
    }

    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        throw new UnsupportedOperationException("doReceive");
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        Object[] arguments = this.getArgs(event);
        Method invokedMethod = this.getMethodObject(event, this.remoteObject);
        invokedMethod.invoke((Object)this.remoteObject, arguments);
    }

    public UMOMessage doSend(UMOEvent event) throws IllegalAccessException, InvocationTargetException, Exception {
        Object[] arguments = this.getArgs(event);
        Method invokedMethod = this.getMethodObject(event, this.remoteObject);
        Object result = invokedMethod.invoke((Object)this.remoteObject, arguments);
        return null == result ? null : new MuleMessage(this.connector.getMessageAdapter(result).getPayload());
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected void doDispose() {
    }

    private Object[] getArgs(UMOEvent event) throws TransformerException {
        Object[] objectArray;
        Object payload = event.getTransformedMessage();
        if (payload instanceof Object[]) {
            objectArray = (Object[])payload;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = payload;
        }
        return objectArray;
    }
}

