/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ejb;

import java.lang.reflect.Method;
import java.rmi.RMISecurityManager;
import javax.ejb.EJBObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.providers.PollingMessageReceiver;
import org.mule.providers.ejb.EjbConnector;
import org.mule.providers.ejb.EjbConnectorUtil;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public class EjbMessageReceiver
extends PollingMessageReceiver {
    protected transient Log logger = LogFactory.getLog((Class)EjbMessageReceiver.class);
    protected EjbConnector connector;
    protected EJBObject remoteObject;
    protected Method invokedMethod;

    public EjbMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Long frequency) throws InitialisationException {
        super(connector, component, endpoint, frequency);
        this.connector = (EjbConnector)connector;
    }

    public void doConnect() throws Exception {
        System.setProperty("java.security.policy", this.connector.getSecurityPolicy());
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        this.remoteObject = EjbConnectorUtil.getRemoteObject(this.getEndpoint(), this.connector);
        this.invokedMethod = EjbConnectorUtil.getMethodObject(this.getEndpoint(), this.remoteObject, this.connector, ((Object)((Object)this)).getClass());
    }

    public void doDisconnect() {
    }

    public void poll() {
        this.logger.debug((Object)"polling....");
        try {
            Object result = this.invokedMethod.invoke((Object)this.remoteObject, this.connector.getEjbAble().arguments());
            if (null != result) {
                Object payload = this.connector.getMessageAdapter(result).getPayload();
                this.routeMessage((UMOMessage)new MuleMessage(payload), this.endpoint.isSynchronous());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

