/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.container;

import java.lang.reflect.Method;
import javax.ejb.EJBHome;
import javax.naming.NamingException;
import org.mule.impl.container.RmiContainerContext;
import org.mule.providers.ejb.i18n.EjbMessages;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.util.ClassUtils;

public class EjbContainerContext
extends RmiContainerContext {
    public EjbContainerContext() {
        super("ejb");
    }

    protected EjbContainerContext(String name) {
        super(name);
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        Object homeObject = null;
        if (key == null) {
            throw new ObjectNotFoundException("null");
        }
        try {
            homeObject = this.context.lookup(key.toString());
        }
        catch (NamingException e) {
            throw new ObjectNotFoundException(key.toString(), (Throwable)e);
        }
        if (homeObject == null) {
            throw new ObjectNotFoundException(key.toString());
        }
        if (homeObject instanceof EJBHome) {
            Method method = ClassUtils.getMethod(homeObject.getClass(), (String)"create", null);
            if (method == null) {
                throw new ObjectNotFoundException(key.toString(), (Throwable)new IllegalArgumentException(EjbMessages.ejbObjectMissingCreate(key).toString()));
            }
            try {
                return method.invoke(homeObject, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new ObjectNotFoundException(key.toString(), (Throwable)e);
            }
        }
        throw new ObjectNotFoundException(key.toString(), (Throwable)new IllegalArgumentException(EjbMessages.ejbKeyRefNotValid(key).toString()));
    }
}

