/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.email;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.URLName;
import org.mule.providers.AbstractConnector;
import org.mule.providers.email.DefaultAuthenticator;
import org.mule.providers.email.SessionDetails;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.StringUtils;

public abstract class AbstractMailConnector
extends AbstractConnector {
    public static final String MAILBOX = "INBOX";
    private Map sessions = new HashMap();
    private String mailboxFolder;
    private int defaultPort;
    private Authenticator authenticator = null;

    public AbstractMailConnector(int defaultPort, String mailboxFolder) {
        this.defaultPort = defaultPort;
        this.mailboxFolder = mailboxFolder;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public String getMailboxFolder() {
        return this.mailboxFolder;
    }

    public void setMailboxFolder(String mailboxFolder) {
        this.mailboxFolder = mailboxFolder;
    }

    public synchronized SessionDetails getSessionDetails(UMOImmutableEndpoint endpoint) {
        SessionDetails sessionDetails = (SessionDetails)this.sessions.get(endpoint);
        if (null == sessionDetails) {
            sessionDetails = this.newSession(endpoint);
            this.sessions.put(endpoint, sessionDetails);
        }
        return sessionDetails;
    }

    public URLName urlFromEndpoint(UMOImmutableEndpoint endpoint) {
        String inbox = endpoint.getEndpointURI().getPath();
        inbox = inbox.length() == 0 ? this.getMailboxFolder() : inbox.substring(1);
        UMOEndpointURI uri = endpoint.getEndpointURI();
        return new URLName(uri.getScheme(), uri.getHost(), uri.getPort(), inbox, uri.getUser(), uri.getPassword());
    }

    protected String getBaseProtocol() {
        return this.getProtocol();
    }

    protected void extendPropertiesForSession(Properties global, Properties local, URLName url) {
        int port = url.getPort();
        if (port == -1) {
            port = this.getDefaultPort();
        }
        local.setProperty("mail." + this.getBaseProtocol() + ".socketFactory.port", Integer.toString(port));
        if (StringUtils.isNotBlank((String)url.getPassword())) {
            local.setProperty("mail." + this.getBaseProtocol() + ".auth", "true");
            if (this.getAuthenticator() == null) {
                this.setAuthenticator(new DefaultAuthenticator(url.getUsername(), url.getPassword()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No Authenticator set on connector: " + this.getName() + "; using default."));
                }
            }
        } else {
            local.setProperty("mail." + this.getBaseProtocol() + ".auth", "false");
        }
        if (StringUtils.isNotBlank((String)url.getHost())) {
            local.setProperty("mail." + this.getBaseProtocol() + ".host", url.getHost());
        }
        local.setProperty("mail." + this.getBaseProtocol() + ".rsetbeforequit", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionDetails newSession(UMOImmutableEndpoint endpoint) {
        Session session;
        URLName url = this.urlFromEndpoint(endpoint);
        Properties global = System.getProperties();
        Properties local = new Properties();
        Properties properties = global;
        synchronized (properties) {
            this.extendPropertiesForSession(global, local, url);
            session = Session.getInstance((Properties)local, (Authenticator)this.getAuthenticator());
        }
        if (this.logger.isDebugEnabled()) {
            local.setProperty("mail.debug", "true");
            this.dumpProperties("Session local properties", local, true);
            this.dumpProperties("System global properties", global, true);
            this.logger.debug((Object)("Creating mail session: host = " + url.getHost() + ", port = " + url.getPort() + ", user = " + url.getUsername() + ", pass = " + url.getPassword()));
        }
        return new SessionDetails(session, url);
    }

    protected void dumpProperties(String title, Properties properties, boolean filter) {
        int skipped = 0;
        this.logger.debug((Object)(title + " ============="));
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!filter || key.startsWith("mule.") || key.startsWith("mail.") || key.startsWith("javax.")) {
                String value = properties.getProperty(key);
                this.logger.debug((Object)(key + ": " + value));
                continue;
            }
            ++skipped;
        }
        if (filter) {
            this.logger.debug((Object)("skipped " + skipped));
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }
}

