/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.email;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import org.mule.providers.email.MailUtils;
import org.mule.providers.email.SimpleMailMessageAdapter;

public class MailMessageAdapter
extends SimpleMailMessageAdapter {
    private static final long serialVersionUID = -6013198455030918360L;
    public static final String ATTACHMENT_HEADERS_PROPERTY_POSTFIX = "Headers";

    public MailMessageAdapter(Object object) throws org.mule.umo.MessagingException {
        super(object);
    }

    protected void handleMessage(Message message) throws Exception {
        Object content = message.getContent();
        if (content instanceof Multipart) {
            TreeMap attachments = new TreeMap();
            MailUtils.getAttachments((Multipart)content, attachments);
            logger.debug((Object)"Received Multipart message");
            int i = 0;
            Iterator iterator = attachments.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Part part = (Part)entry.getValue();
                String name = entry.getKey().toString();
                if (i == 0) {
                    this.setMessage(part);
                } else {
                    this.addAttachment(name, part.getDataHandler());
                    this.addAttachmentHeaders(name, part);
                }
                ++i;
            }
        } else {
            this.setMessage((Part)message);
        }
    }

    protected void addAttachmentHeaders(String name, Part part) throws MessagingException {
        HashMap<String, String> headers = new HashMap<String, String>(4);
        Enumeration e = part.getAllHeaders();
        while (e.hasMoreElements()) {
            Header h = (Header)e.nextElement();
            headers.put(h.getName(), h.getValue());
        }
        if (headers.size() > 0) {
            this.setProperty(name + ATTACHMENT_HEADERS_PROPERTY_POSTFIX, headers);
        }
    }
}

