/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.email;

import java.util.Calendar;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.email.MailUtils;
import org.mule.providers.email.SmtpConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;

public class SmtpMessageDispatcher
extends AbstractMessageDispatcher {
    private volatile Transport transport;

    public SmtpMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
    }

    private SmtpConnector castConnector() {
        return (SmtpConnector)this.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.transport == null) {
            try {
                this.transport = this.castConnector().getSessionDetails(this.endpoint).newTransport();
                UMOEndpointURI uri = this.endpoint.getEndpointURI();
                this.transport.connect(uri.getHost(), uri.getPort(), uri.getUser(), uri.getPassword());
            }
            catch (Exception e) {
                throw new EndpointException(MessageFactory.createStaticMessage((String)"Unable to connect to mail transport."), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        if (null != this.transport) {
            try {
                this.transport.close();
            }
            finally {
                this.transport = null;
            }
        }
    }

    protected void doDispatch(UMOEvent event) {
        try {
            Object data = event.getTransformedMessage();
            if (!(data instanceof Message)) {
                throw new DispatchException(CoreMessages.transformUnexpectedType(data.getClass(), (Class)Message.class), event.getMessage(), event.getEndpoint());
            }
            this.sendMailMessage((Message)data);
        }
        catch (Exception e) {
            this.connector.handleException(e);
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return null;
    }

    protected void sendMailMessage(Message message) throws MessagingException {
        message.setSentDate(Calendar.getInstance().getTime());
        if (!this.transport.isConnected()) {
            UMOEndpointURI uri = this.endpoint.getEndpointURI();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Connection closed by remote server. Reconnecting.");
            }
            this.transport.connect(uri.getHost(), uri.getPort(), uri.getUser(), uri.getPassword());
        }
        this.transport.sendMessage(message, message.getAllRecipients());
        if (this.logger.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Email message sent with subject'").append(message.getSubject()).append("' sent- ");
            msg.append(", From: ").append(MailUtils.mailAddressesToString(message.getFrom())).append(" ");
            msg.append(", To: ").append(MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.TO))).append(" ");
            msg.append(", Cc: ").append(MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.CC))).append(" ");
            msg.append(", Bcc: ").append(MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.BCC))).append(" ");
            msg.append(", ReplyTo: ").append(MailUtils.mailAddressesToString(message.getReplyTo()));
            this.logger.debug((Object)msg.toString());
        }
    }

    protected void doDispose() {
    }
}

