/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.email;

import java.io.IOException;
import java.util.Properties;
import javax.mail.URLName;
import org.mule.providers.email.SmtpConnector;
import org.mule.providers.email.SmtpsSocketFactory;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.TlsIndirectKeyStore;
import org.mule.umo.security.TlsIndirectTrustStore;
import org.mule.umo.security.tls.TlsConfiguration;
import org.mule.umo.security.tls.TlsPropertiesMapper;

public class SmtpsConnector
extends SmtpConnector
implements TlsIndirectTrustStore,
TlsIndirectKeyStore {
    public static final String SMTPS = "smtps";
    public static final String DEFAULT_SOCKET_FACTORY = SmtpsSocketFactory.class.getName();
    private String socketFactory = DEFAULT_SOCKET_FACTORY;
    private String socketFactoryFallback = "false";
    private TlsConfiguration tls = new TlsConfiguration(".keystore");
    public static final int DEFAULT_SMTPS_PORT = 465;

    public SmtpsConnector() {
        super(465);
    }

    public String getProtocol() {
        return SMTPS;
    }

    public String getBaseProtocol() {
        return "smtp";
    }

    protected void doInitialise() throws InitialisationException {
        try {
            this.tls.initialise(true, null);
        }
        catch (CreateException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void extendPropertiesForSession(Properties global, Properties local, URLName url) {
        super.extendPropertiesForSession(global, local, url);
        local.setProperty("mail." + this.getProtocol() + ".ssl", "true");
        local.setProperty("mail." + this.getProtocol() + ".socketFactory.class", this.getSocketFactory());
        local.setProperty("mail." + this.getProtocol() + ".socketFactory.fallback", this.getSocketFactoryFallback());
        new TlsPropertiesMapper("mule.email.smtps").writeToProperties(global, this.tls);
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(String sslSocketFactory) {
        this.socketFactory = sslSocketFactory;
    }

    public String getSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    public void setSocketFactoryFallback(String socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
    }

    public String getTrustStore() {
        return this.tls.getTrustStore();
    }

    public String getTrustStorePassword() {
        return this.tls.getTrustStorePassword();
    }

    public void setTrustStore(String trustStore) throws IOException {
        this.tls.setTrustStore(trustStore);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.tls.setTrustStorePassword(trustStorePassword);
    }

    public String getClientKeyStore() {
        return this.tls.getClientKeyStore();
    }

    public String getClientKeyStorePassword() {
        return this.tls.getClientKeyStorePassword();
    }

    public String getClientKeyStoreType() {
        return this.tls.getClientKeyStoreType();
    }

    public void setClientKeyStore(String name) throws IOException {
        this.tls.setClientKeyStore(name);
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.tls.setClientKeyStorePassword(clientKeyStorePassword);
    }

    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.tls.setClientKeyStoreType(clientKeyStoreType);
    }
}

