/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.email.transformers;

import javax.mail.Message;
import javax.mail.internet.MimeMultipart;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class EmailMessageToString
extends AbstractTransformer {
    public EmailMessageToString() {
        this.registerSourceType(Message.class);
        this.setReturnClass(String.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        Message msg = (Message)src;
        try {
            Object result = msg.getContent();
            if (result instanceof String) {
                return result;
            }
            MimeMultipart part = (MimeMultipart)result;
            String transMsg = (String)part.getBodyPart(0).getContent();
            return transMsg;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }
}

