/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.email.transformers;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.email.transformers.PlainTextDataSource;
import org.mule.providers.email.transformers.StringToEmailMessage;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.StringUtils;

public class ObjectToMimeMessage
extends StringToEmailMessage {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void setContent(Object payload, Message msg, String contentType, UMOMessage message) throws Exception {
        if (message.getAttachmentNames().size() > 0) {
            MimeMultipart multipart = new MimeMultipart("mixed");
            multipart.addBodyPart(this.getPayloadBodyPart(message.getPayload(), contentType));
            Iterator it = message.getAttachmentNames().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                BodyPart part = this.getBodyPartForAttachment(message.getAttachment(name), name);
                this.addBodyPartHeaders(part, name, message);
                multipart.addBodyPart(part);
            }
            payload = multipart;
            contentType = multipart.getContentType();
        }
        super.setContent(payload, msg, contentType, message);
    }

    protected void addBodyPartHeaders(BodyPart part, String name, UMOMessage message) {
        Map headers = (Map)message.getProperty(name + "Headers");
        if (null != headers) {
            Iterator it = headers.keySet().iterator();
            while (it.hasNext()) {
                try {
                    String key = (String)it.next();
                    part.setHeader(key, (String)headers.get(key));
                }
                catch (MessagingException me) {
                    this.logger.error((Object)"Failed to set bodypart header", (Throwable)me);
                }
            }
        }
    }

    protected BodyPart getBodyPartForAttachment(DataHandler handler, String name) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(handler);
        part.setDescription(name);
        DataSource source = handler.getDataSource();
        if (source instanceof FileDataSource) {
            part.setFileName(StringUtils.defaultString((String)handler.getName(), (String)name));
        }
        return part;
    }

    /*
     * WARNING - void declaration
     */
    protected BodyPart getPayloadBodyPart(Object payload, String contentType) throws MessagingException, TransformerException, IOException {
        void var3_3;
        DataHandler handler;
        if (payload instanceof String) {
            handler = new DataHandler((DataSource)new PlainTextDataSource(contentType, payload.toString()));
        } else if (payload instanceof byte[]) {
            handler = new DataHandler((DataSource)new ByteArrayDataSource((byte[])payload, contentType));
        } else if (payload instanceof Serializable) {
            handler = new DataHandler((DataSource)new ByteArrayDataSource((byte[])new SerializableToByteArray().transform(payload), contentType));
        } else {
            throw new IllegalArgumentException();
        }
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler((DataHandler)var3_3);
        part.setDescription("Payload");
        return part;
    }
}

