/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.email.transformers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.mule.providers.email.AbstractMailConnector;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class Rfc822ByteArraytoMimeMessage
extends AbstractTransformer {
    public Rfc822ByteArraytoMimeMessage() {
        this.registerSourceType([B.class);
        this.setReturnClass(MimeMessage.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            byte[] bytes = (byte[])src;
            return new MimeMessage(this.getSession(), (InputStream)new ByteArrayInputStream(bytes));
        }
        catch (MessagingException e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected Session getSession() throws TransformerException {
        if (null == this.endpoint) {
            throw new TransformerException((UMOTransformer)this, (Throwable)new IllegalStateException("The transformer is no associated with an endpoint."));
        }
        UMOConnector connector = this.endpoint.getConnector();
        if (!(connector instanceof AbstractMailConnector)) {
            throw new TransformerException((UMOTransformer)this, (Throwable)new IllegalStateException("The transformer is not associated with an email endpoint."));
        }
        return ((AbstractMailConnector)connector).getSessionDetails(this.endpoint).getSession();
    }
}

