/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transport.email.AbstractMailConnector;

public class Rfc822ByteArraytoMimeMessage
extends AbstractTransformer {
    public Rfc822ByteArraytoMimeMessage() {
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.setReturnClass(MimeMessage.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            if (src instanceof byte[]) {
                byte[] bytes = (byte[])src;
                return new MimeMessage(this.getSession(), (InputStream)new ByteArrayInputStream(bytes));
            }
            if (src instanceof InputStream) {
                return new MimeMessage(this.getSession(), (InputStream)src);
            }
            throw new TransformerException(CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint((String)this.getName(), src.getClass(), (ImmutableEndpoint)this.endpoint));
        }
        catch (MessagingException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected Session getSession() throws TransformerException {
        if (null == this.endpoint) {
            throw new TransformerException((Transformer)this, (Throwable)new IllegalStateException("The transformer is no associated with an endpoint."));
        }
        Connector connector = this.endpoint.getConnector();
        if (!(connector instanceof AbstractMailConnector)) {
            throw new TransformerException((Transformer)this, (Throwable)new IllegalStateException("The transformer is not associated with an email endpoint."));
        }
        try {
            return ((AbstractMailConnector)connector).getSessionDetails(this.endpoint).getSession();
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }
}

