/*
 * $Id: MimeMessageToRfc822ByteArray.java 17453 2010-06-02 10:27:30Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.email.transformers;

import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

import java.io.ByteArrayOutputStream;

import javax.mail.internet.MimeMessage;

public class MimeMessageToRfc822ByteArray extends AbstractTransformer
{

    public MimeMessageToRfc822ByteArray()
    {
        registerSourceType(MimeMessage.class);
        setReturnDataType(DataTypeFactory.create(byte[].class));
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException
    {
        try
        {
            MimeMessage mime = (MimeMessage) src;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mime.writeTo(baos);
            return baos.toByteArray();
        }
        catch (Exception e)
        {
            throw new TransformerException(this, e);
        }
    }

}
