/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.simple.SerializableToByteArray;
import org.mule.transport.email.transformers.StringToEmailMessage;
import org.mule.util.StringUtils;

public class ObjectToMimeMessage
extends StringToEmailMessage {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean useInboundAttachments = true;
    private boolean useOutboundAttachments = true;

    protected void setContent(Object payload, Message msg, String contentType, MuleMessage message) throws Exception {
        boolean transformOutboundAttachments;
        boolean transformInboundAttachments = this.useInboundAttachments && message.getInboundAttachmentNames().size() > 0;
        boolean bl = transformOutboundAttachments = this.useOutboundAttachments && message.getOutboundAttachmentNames().size() > 0;
        if (transformInboundAttachments || transformOutboundAttachments) {
            BodyPart part;
            MimeMultipart multipart = new MimeMultipart("mixed");
            multipart.addBodyPart(this.getPayloadBodyPart(message.getPayload(), contentType));
            if (transformInboundAttachments) {
                for (String name : message.getInboundAttachmentNames()) {
                    if (transformOutboundAttachments && message.getOutboundAttachment(name) != null) continue;
                    part = this.getBodyPartForAttachment(message.getInboundAttachment(name), name);
                    this.addBodyPartHeaders(part, name, message);
                    multipart.addBodyPart(part);
                }
            }
            if (transformOutboundAttachments) {
                for (String name : message.getOutboundAttachmentNames()) {
                    part = this.getBodyPartForAttachment(message.getOutboundAttachment(name), name);
                    this.addBodyPartHeaders(part, name, message);
                    multipart.addBodyPart(part);
                }
            }
            payload = multipart;
            contentType = multipart.getContentType();
        }
        super.setContent(payload, msg, contentType, message);
    }

    protected void addBodyPartHeaders(BodyPart part, String name, MuleMessage message) {
        Map headers = (Map)message.getOutboundProperty(name + "Headers");
        if (null != headers) {
            for (String key : headers.keySet()) {
                try {
                    part.setHeader(key, (String)headers.get(key));
                }
                catch (MessagingException me) {
                    this.logger.error((Object)"Failed to set bodypart header", (Throwable)me);
                }
            }
        }
    }

    protected BodyPart getBodyPartForAttachment(DataHandler handler, String name) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(handler);
        part.setDescription(name);
        part.setFileName(StringUtils.defaultString((String)handler.getName(), (String)name));
        return part;
    }

    protected BodyPart getPayloadBodyPart(Object payload, String contentType) throws MessagingException, TransformerException, IOException {
        DataHandler handler;
        if (payload instanceof String) {
            handler = new DataHandler((DataSource)new ByteArrayDataSource((String)payload, contentType));
        } else if (payload instanceof byte[]) {
            handler = new DataHandler((DataSource)new ByteArrayDataSource((byte[])payload, contentType));
        } else if (payload instanceof Serializable) {
            handler = new DataHandler((DataSource)new ByteArrayDataSource((byte[])new SerializableToByteArray().transform(payload), contentType));
        } else {
            throw new IllegalArgumentException();
        }
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(handler);
        part.setDescription("Payload");
        return part;
    }

    public void setUseInboundAttachments(boolean useInboundAttachments) {
        this.useInboundAttachments = useInboundAttachments;
    }

    public void setUseOutboundAttachments(boolean useOutboundAttachments) {
        this.useOutboundAttachments = useOutboundAttachments;
    }
}

