/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.email.MailUtils;
import org.mule.transport.email.SmtpConnector;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;
import org.mule.util.TemplateParser;

public class StringToEmailMessage
extends AbstractMessageTransformer {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TemplateParser templateParser = TemplateParser.createMuleStyleParser();

    public StringToEmailMessage() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.setReturnDataType(DataTypeFactory.create(Message.class));
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Properties otherHeaders;
        String endpointAddress = this.endpoint.getEndpointURI().getAddress();
        SmtpConnector connector = (SmtpConnector)this.endpoint.getConnector();
        String to = this.lookupProperty(message, "toAddresses", endpointAddress);
        String cc = this.lookupProperty(message, "ccAddresses", connector.getCcAddresses());
        String bcc = this.lookupProperty(message, "bccAddresses", connector.getBccAddresses());
        String from = this.lookupProperty(message, "fromAddress", connector.getFromAddress());
        String replyTo = this.lookupProperty(message, "replyToAddresses", connector.getReplyToAddresses());
        String subject = this.lookupProperty(message, "subject", connector.getSubject());
        String contentType = this.lookupProperty(message, "contentType", connector.getContentType());
        Properties headers = new Properties();
        Properties customHeaders = connector.getCustomHeaders();
        if (customHeaders != null && !customHeaders.isEmpty()) {
            headers.putAll((Map<?, ?>)customHeaders);
        }
        if ((otherHeaders = (Properties)message.getOutboundProperty("customHeaders")) != null && !otherHeaders.isEmpty()) {
            headers.putAll((Map<?, ?>)this.templateParser.parse(new TemplateParser.TemplateCallback(){

                public Object match(String token) {
                    return StringToEmailMessage.this.muleContext.getRegistry().lookupObject(token);
                }
            }, (Map)otherHeaders));
        }
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Constructing email using:\n");
            buf.append("To: ").append(to);
            buf.append(", From: ").append(from);
            buf.append(", CC: ").append(cc);
            buf.append(", BCC: ").append(bcc);
            buf.append(", Subject: ").append(subject);
            buf.append(", ReplyTo: ").append(replyTo);
            buf.append(", Content type: ").append(contentType);
            buf.append(", Payload type: ").append(message.getPayload().getClass().getName());
            buf.append(", Custom Headers: ").append(MapUtils.toString((Map)headers, (boolean)false));
            this.logger.debug((Object)buf.toString());
        }
        try {
            MimeMessage email = new MimeMessage(((SmtpConnector)this.endpoint.getConnector()).getSessionDetails(this.endpoint).getSession());
            email.setRecipients(Message.RecipientType.TO, (Address[])MailUtils.stringToInternetAddresses(to));
            email.setSentDate(Calendar.getInstance().getTime());
            if (StringUtils.isNotBlank((String)from)) {
                email.setFrom((Address)MailUtils.stringToInternetAddresses(from)[0]);
            }
            if (StringUtils.isNotBlank((String)cc)) {
                email.setRecipients(Message.RecipientType.CC, (Address[])MailUtils.stringToInternetAddresses(cc));
            }
            if (StringUtils.isNotBlank((String)bcc)) {
                email.setRecipients(Message.RecipientType.BCC, (Address[])MailUtils.stringToInternetAddresses(bcc));
            }
            if (StringUtils.isNotBlank((String)replyTo)) {
                email.setReplyTo((Address[])MailUtils.stringToInternetAddresses(replyTo));
            }
            email.setSubject(subject);
            for (Map.Entry<Object, Object> entry : headers.entrySet()) {
                email.setHeader(entry.getKey().toString(), entry.getValue().toString());
            }
            this.setContent(message.getPayload(), (Message)email, contentType, message);
            return email;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected String lookupProperty(MuleMessage message, String propName, String defaultValue) {
        String value = (String)message.getOutboundProperty(propName);
        if (value == null) {
            value = (String)message.getInvocationProperty(propName, (Object)defaultValue);
        }
        return value;
    }

    protected void setContent(Object payload, Message msg, String contentType, MuleMessage message) throws Exception {
        msg.setContent(payload, contentType);
    }
}

