/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractGreenMailSupport {
    public static final String LOCALHOST = "127.0.0.1";
    public static final String MESSAGE = "Test Email Message";
    public static final String AT_EXAMPLE_COM = "@example.com";
    public static final String BOB = "bob";
    public static final String BOB_EMAIL = "bob@example.com";
    public static final String ALICE = "alice";
    public static final String ALICE_EMAIL = "alice@example.com";
    public static final String PASSWORD = "secret";
    public static final long STARTUP_PERIOD_MS = 100L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private GreenMail servers;

    protected void createUserAndStoreEmail(String email, String user, String password, Object message) throws Exception {
        this.logger.debug((Object)("Creating mail user " + user + "/" + email + "/" + password));
        GreenMailUser target = this.createUser(email, user, password);
        target.deliver((MimeMessage)message);
        Thread.sleep(100L);
    }

    public GreenMailUser createUser(String email, String user, String password) throws UserException {
        UserManager userManager = this.servers.getManagers().getUserManager();
        userManager.createUser(email, user, password);
        GreenMailUser target = userManager.getUser(user);
        if (null == target) {
            throw new IllegalStateException("Failure in greenmail - see comments in test code.");
        }
        return target;
    }

    public void createBobAndStoreEmail(Object message) throws Exception {
        this.createUserAndStoreEmail(BOB_EMAIL, BOB, PASSWORD, message);
    }

    public void createAliceAndStoreEmail(Object message) throws Exception {
        this.createUserAndStoreEmail(ALICE_EMAIL, ALICE, PASSWORD, message);
    }

    public void startServers(List<Integer> list) throws Exception {
        this.logger.info((Object)"Starting mail servers");
        this.servers = new GreenMail(this.getSetups(list));
        this.servers.start();
        Thread.sleep(100L);
    }

    protected abstract int nextPort();

    private ServerSetup[] getSetups(List<Integer> list) {
        if (list.size() != 6) {
            throw new IllegalArgumentException("must pass in an array of 6 ports for server setup");
        }
        return new ServerSetup[]{this.newServerSetup(list.get(0), "pop3"), this.newServerSetup(list.get(1), "smtp"), this.newServerSetup(list.get(2), "smtps"), this.newServerSetup(list.get(3), "pop3s"), this.newServerSetup(list.get(4), "imap"), this.newServerSetup(list.get(5), "imaps")};
    }

    private ServerSetup newServerSetup(int port, String protocol) {
        this.logger.debug((Object)("Server for " + protocol + " will be on port " + port));
        return new ServerSetup(port, null, protocol);
    }

    protected void stopServers() throws Exception {
        this.logger.info((Object)"Stopping mail servers");
        if (null != this.servers) {
            this.servers.stop();
        }
    }

    public GreenMail getServers() {
        return this.servers;
    }

    public MimeMessage getValidMessage(String to) throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setContent((Object)MESSAGE, "text/plain");
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        return message;
    }
}

