/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.email.AbstractGreenMailSupport;
import org.mule.transport.email.FixedPortGreenMailSupport;

public class EmailRoundTripTestCase
extends AbstractServiceAndFlowTestCase {
    private AbstractGreenMailSupport greenMailSupport = null;
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");
    @Rule
    public DynamicPort dynamicPort4 = new DynamicPort("port4");
    @Rule
    public DynamicPort dynamicPort5 = new DynamicPort("port5");
    @Rule
    public DynamicPort dynamicPort6 = new DynamicPort("port6");

    public EmailRoundTripTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "email-round-trip-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "email-round-trip-test-flow.xml"});
    }

    protected MuleContext createMuleContext() throws Exception {
        this.startServer();
        return super.createMuleContext();
    }

    public void startServer() throws Exception {
        this.greenMailSupport = new FixedPortGreenMailSupport(this.dynamicPort2.getNumber());
        ArrayList<Integer> ports = new ArrayList<Integer>(6);
        ports.add(this.dynamicPort1.getNumber());
        ports.add(this.dynamicPort2.getNumber());
        ports.add(this.dynamicPort3.getNumber());
        ports.add(this.dynamicPort4.getNumber());
        ports.add(this.dynamicPort5.getNumber());
        ports.add(this.dynamicPort6.getNumber());
        this.greenMailSupport.startServers(ports);
        this.greenMailSupport.createBobAndStoreEmail(this.greenMailSupport.getValidMessage("alice@example.com"));
    }

    protected void doTearDown() throws Exception {
        this.greenMailSupport.stopServers();
        super.doTearDown();
    }

    @Test
    public void testRoundTrip() throws MuleException, InterruptedException {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.request("vm://rfc822", 5000L);
        Assert.assertTrue((boolean)(message.getPayload() instanceof byte[]));
        this.greenMailSupport.getServers().waitForIncomingEmail(10000L, 1);
        MimeMessage[] messages = this.greenMailSupport.getServers().getReceivedMessages();
        Assert.assertNotNull((String)"did not receive any messages", (Object)messages);
        Assert.assertEquals((String)"did not receive 1 mail", (long)1L, (long)messages.length);
    }
}

