/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.GreenMail;
import java.net.Socket;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GreenMailUtilities {
    protected static Log logger = LogFactory.getLog(GreenMailUtilities.class);

    public static void storeEmail(UserManager userManager, String email, String user, String password, MimeMessage message) throws Exception {
        GreenMailUser gmUser = userManager.getUser(user);
        if (gmUser == null || gmUser.getEmail() != email || gmUser.getPassword() != password) {
            userManager.createUser(email, user, password);
            gmUser = userManager.getUser(user);
        }
        assert (null != gmUser);
        gmUser.deliver(message);
    }

    public static MimeMessage toMessage(String text, String email, String charset) throws MessagingException {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        if (charset != null) {
            message.setContent((Object)text, "text/plain; charset=" + charset);
        } else {
            message.setContent((Object)text, "text/plain");
        }
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
        return message;
    }

    public static void waitForStartup(String host, int port, int count, long wait) throws InterruptedException {
        for (int i = 0; i < count; ++i) {
            Thread.sleep(wait);
            try {
                Socket socket = new Socket(host, port);
                socket.close();
                logger.info((Object)("Successful connection made to port " + port));
                return;
            }
            catch (Exception e) {
                logger.warn((Object)("Could not connect to server on " + host + ":" + port + " - " + e.getMessage()));
                continue;
            }
        }
        throw new RuntimeException("Server failed to start within " + (long)count * wait + "ms");
    }

    public static void robustStartup(GreenMail servers, String host, int port, int startMax, int testMax, long wait) throws InterruptedException {
        for (int start = 0; start < startMax; ++start) {
            try {
                servers.start();
                GreenMailUtilities.waitForStartup(host, port, testMax, wait);
                return;
            }
            catch (Exception e) {
                try {
                    servers.stop();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Thread.sleep(wait);
                continue;
            }
        }
    }
}

