/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.email.MailMuleMessageFactory;

public class MailMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new MailMuleMessageFactory(muleContext);
    }

    protected MimeMessage getValidTransportMessage() throws Exception {
        MimeMessage message = new MimeMessage((Session)null);
        message.setContent((Object)"Test Message", "text/plain; charset=ISO-8859-1");
        return message;
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is not a valid transport message for MailMuleMessageFactory";
    }

    @Test
    public void testAttachments() throws Exception {
        Message payload = this.createMimeMessageWithAttachment();
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage muleMessage = factory.create((Object)payload, this.encoding);
        Assert.assertEquals((long)2L, (long)muleMessage.getInboundAttachmentNames().size());
    }

    @Test
    public void testAddRecipientProperties() throws Exception {
        String to = "Information <info@domain.com>";
        String cc = "\"info@\" <domain.com info@domain.com>";
        String bcc = "'invalid@domain.com', info <info@domain.com>";
        MimeMessage payload = this.getValidTransportMessage();
        payload.setHeader(Message.RecipientType.TO.toString(), to);
        payload.setHeader(Message.RecipientType.CC.toString(), cc);
        payload.setHeader(Message.RecipientType.BCC.toString(), bcc);
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage muleMessage = factory.create((Object)payload, this.encoding);
        Assert.assertEquals((Object)to, (Object)muleMessage.getOutboundProperty("inbound.toAddresses"));
        Assert.assertEquals((Object)cc, (Object)muleMessage.getOutboundProperty("inbound.ccAddresses"));
        Assert.assertEquals((Object)bcc, (Object)muleMessage.getOutboundProperty("inbound.bccAddresses"));
    }

    @Test
    public void testAttachmentsWithSameName() throws Exception {
        Message payload = this.createMimeMessageWithSameAttachmentNames();
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage muleMessage = factory.create((Object)payload, this.encoding);
        Assert.assertEquals((long)3L, (long)muleMessage.getInboundAttachmentNames().size());
    }

    private Message createMimeMessageWithAttachment() throws Exception {
        MimeBodyPart mainBody = new MimeBodyPart();
        mainBody.setText("This is the main message text");
        MimeBodyPart attachment = this.createBodyPart("Test Message", "message.txt");
        Multipart multipart = this.createMultipart(new BodyPart[]{mainBody, attachment});
        MimeMessage message = this.getValidTransportMessage();
        message.setContent(multipart);
        return message;
    }

    private Message createMimeMessageWithSameAttachmentNames() throws Exception {
        MimeBodyPart mainBody = new MimeBodyPart();
        mainBody.setText("This is the main message text");
        MimeBodyPart firstAttachment = this.createBodyPart("The first attachment content", "message.txt");
        MimeBodyPart secondAttachment = this.createBodyPart("The second attachment content", "message.txt");
        Multipart multipart = this.createMultipart(new BodyPart[]{mainBody, firstAttachment, secondAttachment});
        MimeMessage message = this.getValidTransportMessage();
        message.setContent(multipart);
        return message;
    }

    private MimeBodyPart createBodyPart(String content, String fileName) throws MessagingException {
        MimeBodyPart attachment = new MimeBodyPart();
        ByteArrayDataSource source = new ByteArrayDataSource(content.getBytes(), "text/plain");
        attachment.setDataHandler(new DataHandler((DataSource)source));
        attachment.setFileName(fileName);
        return attachment;
    }

    private Multipart createMultipart(BodyPart ... parts) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        for (BodyPart part : parts) {
            multipart.addBodyPart(part);
        }
        return multipart;
    }
}

