/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.collections.map.HashedMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.email.MailUtils;

public class MailUtilsTestCase
extends AbstractMuleTestCase {
    private static final String EMAIL_1 = "vasya@pupkin.com";
    private static final String EMAIL_2 = "zhora@buryakov.com";
    private InternetAddress inetAddress1;
    private InternetAddress inetAddress2;
    private static final String MULTIPLE_EMAILS_WITH_WHITESPACE = "vasya@pupkin.com, zhora@buryakov.com";
    private static final String MULTIPLE_EMAILS_WITHOUT_WHITESPACE = "vasya@pupkin.com,zhora@buryakov.com";

    @Before
    public void createInternetAddresses() throws AddressException {
        this.inetAddress1 = new InternetAddress(EMAIL_1);
        this.inetAddress2 = new InternetAddress(EMAIL_2);
    }

    @Test
    public void testSingleInternetAddressToString() throws Exception {
        String result = MailUtils.internetAddressesToString((InternetAddress)this.inetAddress1);
        Assert.assertEquals((String)"Wrong internet address conversion.", (Object)EMAIL_1, (Object)result);
    }

    @Test
    public void testMultipleInternetAddressesToString() {
        String result = MailUtils.internetAddressesToString((InternetAddress[])new InternetAddress[]{this.inetAddress1, this.inetAddress2});
        Assert.assertEquals((String)"Wrong internet address conversion.", (Object)MULTIPLE_EMAILS_WITH_WHITESPACE, (Object)result);
    }

    @Test
    public void testStringToSingleInternetAddresses() throws Exception {
        InternetAddress[] result = MailUtils.stringToInternetAddresses((String)EMAIL_1);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Wrong number of addresses parsed.", (long)1L, (long)result.length);
        Assert.assertEquals((String)"Wrong internet address conversion.", (Object)this.inetAddress1, (Object)result[0]);
    }

    @Test
    public void testStringWithWhitespaceToMultipleInternetAddresses() throws Exception {
        InternetAddress[] result = MailUtils.stringToInternetAddresses((String)MULTIPLE_EMAILS_WITH_WHITESPACE);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Wrong number of addresses parsed.", (long)2L, (long)result.length);
        Assert.assertEquals((String)"Wrong internet address conversion.", (Object)this.inetAddress1, (Object)result[0]);
        Assert.assertEquals((String)"Wrong internet address conversion.", (Object)this.inetAddress2, (Object)result[1]);
    }

    @Test
    public void testStringWithoutWhitespaceToMultipleInternetAddresses() throws Exception {
        InternetAddress[] result = MailUtils.stringToInternetAddresses((String)MULTIPLE_EMAILS_WITHOUT_WHITESPACE);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Wrong number of addresses parsed.", (long)2L, (long)result.length);
        Assert.assertEquals((String)"Wrong internet address conversion.", (Object)this.inetAddress1, (Object)result[0]);
        Assert.assertEquals((String)"Wrong internet address conversion.", (Object)this.inetAddress2, (Object)result[1]);
    }

    @Test
    public void testGetAttachmentName() throws Exception {
        HashedMap attachments = new HashedMap();
        String key = "test.txt";
        Assert.assertEquals((Object)key, (Object)MailUtils.getAttachmentName((String)key, (Map)attachments));
        attachments.put(key, new MimeBodyPart());
        Assert.assertEquals((Object)("0_" + key), (Object)MailUtils.getAttachmentName((String)key, (Map)attachments));
    }
}

