/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.config;

import javax.mail.Flags;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.transport.email.ImapConnector;
import org.mule.transport.email.ImapsConnector;
import org.mule.transport.email.config.AbstractEmailNamespaceHandlerTestCase;

public class ImapNamespaceHandlerTestCase
extends AbstractEmailNamespaceHandlerTestCase {
    protected String getConfigResources() {
        return "imap-namespace-config.xml";
    }

    @Test
    public void testConfig() throws Exception {
        ImapConnector c = (ImapConnector)muleContext.getRegistry().lookupConnector("imapConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)c.isBackupEnabled());
        Assert.assertEquals((Object)"newBackup", (Object)c.getBackupFolder());
        Assert.assertEquals((long)1234L, (long)c.getCheckFrequency());
        Assert.assertEquals((Object)"newMailbox", (Object)c.getMailboxFolder());
        Assert.assertEquals((Object)false, (Object)c.isDeleteReadMessages());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertEquals((Object)Flags.Flag.SEEN, (Object)c.getDefaultProcessMessageAction());
    }

    @Test
    public void testSecureConfig() throws Exception {
        ImapsConnector c = (ImapsConnector)muleContext.getRegistry().lookupConnector("imapsConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertFalse((boolean)c.isBackupEnabled());
        Assert.assertEquals((Object)"newBackup", (Object)c.getBackupFolder());
        Assert.assertEquals((long)1234L, (long)c.getCheckFrequency());
        Assert.assertEquals((Object)"newMailbox", (Object)c.getMailboxFolder());
        Assert.assertEquals((Object)false, (Object)c.isDeleteReadMessages());
        Assert.assertTrue((boolean)c.getClientKeyStore().endsWith("/empty.jks"));
        Assert.assertEquals((Object)"password", (Object)c.getClientKeyStorePassword());
        Assert.assertTrue((boolean)c.getTrustStore().endsWith("/empty.jks"));
        Assert.assertEquals((Object)"password", (Object)c.getTrustStorePassword());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertNull((Object)c.getDefaultProcessMessageAction());
    }

    @Test
    public void testEndpoint() throws MuleException {
        this.testInboundEndpoint("global1", "imap");
        this.testInboundEndpoint("global2", "imap");
        this.testInboundEndpoint("global1s", "imaps");
        this.testInboundEndpoint("global2s", "imaps");
    }
}

