/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.config;

import javax.mail.Flags;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.transport.email.Pop3Connector;
import org.mule.transport.email.Pop3sConnector;
import org.mule.transport.email.config.AbstractEmailNamespaceHandlerTestCase;

public class Pop3NamespaceHandlerTestCase
extends AbstractEmailNamespaceHandlerTestCase {
    protected String getConfigResources() {
        return "pop3-namespace-config.xml";
    }

    @Test
    public void testConfig() throws Exception {
        Pop3Connector c = (Pop3Connector)muleContext.getRegistry().lookupConnector("pop3Connector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)c.isBackupEnabled());
        Assert.assertEquals((Object)"newBackup", (Object)c.getBackupFolder());
        Assert.assertEquals((long)1234L, (long)c.getCheckFrequency());
        Assert.assertEquals((Object)"newMailbox", (Object)c.getMailboxFolder());
        Assert.assertEquals((Object)false, (Object)c.isDeleteReadMessages());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertEquals((Object)Flags.Flag.SEEN, (Object)c.getDefaultProcessMessageAction());
    }

    @Test
    public void testSecureConfig() throws Exception {
        Pop3sConnector c = (Pop3sConnector)muleContext.getRegistry().lookupConnector("pop3sConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)c.isBackupEnabled());
        Assert.assertEquals((Object)"newBackup", (Object)c.getBackupFolder());
        Assert.assertEquals((long)1234L, (long)c.getCheckFrequency());
        Assert.assertEquals((Object)"newMailbox", (Object)c.getMailboxFolder());
        Assert.assertEquals((Object)false, (Object)c.isDeleteReadMessages());
        Assert.assertTrue((boolean)c.getClientKeyStore().endsWith("/empty.jks"));
        Assert.assertEquals((Object)"password", (Object)c.getClientKeyStorePassword());
        Assert.assertTrue((boolean)c.getTrustStore().endsWith("/empty.jks"));
        Assert.assertEquals((Object)"password", (Object)c.getTrustStorePassword());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertEquals((Object)Flags.Flag.ANSWERED, (Object)c.getDefaultProcessMessageAction());
    }

    @Test
    public void testEndpoint() throws MuleException {
        this.testInboundEndpoint("global1", "pop3");
        this.testInboundEndpoint("global2", "pop3");
        this.testInboundEndpoint("global1s", "pop3s");
        this.testInboundEndpoint("global2s", "pop3s");
    }
}

