/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.config;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.transport.email.SmtpConnector;
import org.mule.transport.email.SmtpsConnector;
import org.mule.transport.email.config.AbstractEmailNamespaceHandlerTestCase;

public class SmtpNamespaceHandlerTestCase
extends AbstractEmailNamespaceHandlerTestCase {
    protected String getConfigResources() {
        return "smtp-namespace-config.xml";
    }

    @Test
    public void testConfig() throws Exception {
        SmtpConnector c = (SmtpConnector)muleContext.getRegistry().lookupConnector("smtpConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)"abc@example.com", (Object)c.getBccAddresses());
        Assert.assertEquals((Object)"bcd@example.com", (Object)c.getCcAddresses());
        Assert.assertEquals((Object)"foo/bar", (Object)c.getContentType());
        Properties headers = c.getCustomHeaders();
        Assert.assertEquals((long)2L, (long)headers.size());
        Assert.assertEquals((Object)"bar", (Object)headers.getProperty("foo"));
        Assert.assertEquals((Object)"boz", (Object)headers.getProperty("baz"));
        Assert.assertEquals((Object)"cde@example.com", (Object)c.getFromAddress());
        Assert.assertEquals((Object)"def@example.com", (Object)c.getReplyToAddresses());
        Assert.assertEquals((Object)"subject", (Object)c.getSubject());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testSecureConfig() throws Exception {
        SmtpsConnector c = (SmtpsConnector)muleContext.getRegistry().lookupConnector("smtpsConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)"abc@example.com", (Object)c.getBccAddresses());
        Assert.assertEquals((Object)"bcd@example.com", (Object)c.getCcAddresses());
        Assert.assertEquals((Object)"foo/bar", (Object)c.getContentType());
        Properties headers = c.getCustomHeaders();
        Assert.assertEquals((long)2L, (long)headers.size());
        Assert.assertEquals((Object)"bar", (Object)headers.getProperty("foo"));
        Assert.assertEquals((Object)"boz", (Object)headers.getProperty("baz"));
        Assert.assertEquals((Object)"cde@example.com", (Object)c.getFromAddress());
        Assert.assertEquals((Object)"def@example.com", (Object)c.getReplyToAddresses());
        Assert.assertEquals((Object)"subject", (Object)c.getSubject());
        Assert.assertTrue((boolean)c.getClientKeyStore().endsWith("/empty.jks"));
        Assert.assertEquals((Object)"password", (Object)c.getClientKeyStorePassword());
        Assert.assertTrue((boolean)c.getTrustStore().endsWith("/empty.jks"));
        Assert.assertEquals((Object)"password", (Object)c.getTrustStorePassword());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testEndpoint() throws MuleException {
        this.testOutboundEndpoint("global1", "smtp");
        this.testOutboundEndpoint("global2", "smtp");
        this.testOutboundEndpoint("global1s", "smtps");
        this.testOutboundEndpoint("global2s", "smtps");
    }
}

