/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.connectors;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Rule;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.transformer.NoActionTransformer;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.email.GreenMailUtilities;

public abstract class AbstractMailConnectorFunctionalTestCase
extends AbstractConnectorTestCase {
    public static final String LOCALHOST = "127.0.0.1";
    public static final String USER = "bob";
    public static final String PROVIDER = "example.com";
    public static final String EMAIL = "bob@example.com";
    public static final String PASSWORD = "secret";
    public static final String MESSAGE = "Test Email Message";
    public static final int START_ATTEMPTS = 3;
    public static final int TEST_ATTEMPTS = 5;
    public static final long STARTUP_PERIOD_MS = 1000L;
    public static final boolean SEND_INITIAL_EMAIL = true;
    public static final boolean NO_INITIAL_EMAIL = false;
    private static final AtomicInteger nameCount = new AtomicInteger(0);
    private MimeMessage message;
    private GreenMail servers;
    private final boolean initialEmail;
    private String protocol;
    private int port;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected AbstractMailConnectorFunctionalTestCase(boolean initialEmail, String protocol) {
        this.initialEmail = initialEmail;
        this.protocol = protocol;
    }

    protected synchronized void doSetUp() throws Exception {
        super.doSetUp();
        this.port = this.dynamicPort.getNumber();
        this.startServers();
        muleContext.getRegistry().registerObject("noActionTransformer", (Object)new NoActionTransformer());
    }

    protected synchronized void doTearDown() throws Exception {
        this.stopServers();
        super.doTearDown();
    }

    private synchronized void storeEmail() throws Exception {
        GreenMailUtilities.storeEmail(this.servers.getManagers().getUserManager(), EMAIL, USER, PASSWORD, (MimeMessage)this.getValidMessage());
        Assert.assertEquals((long)1L, (long)this.servers.getReceivedMessages().length);
    }

    private synchronized void startServers() throws Exception {
        this.servers = new GreenMail(this.getSetups());
        GreenMailUtilities.robustStartup(this.servers, LOCALHOST, this.port, 3, 5, 1000L);
        if (this.initialEmail) {
            this.storeEmail();
        }
    }

    private ServerSetup[] getSetups() {
        return new ServerSetup[]{new ServerSetup(this.port, null, this.protocol)};
    }

    private synchronized void stopServers() throws Exception {
        if (null != this.servers) {
            try {
                this.servers.stop();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    protected synchronized GreenMail getServers() {
        return this.servers;
    }

    public Object getValidMessage() throws Exception {
        if (null == this.message) {
            this.message = GreenMailUtilities.toMessage(MESSAGE, EMAIL, null);
        }
        return this.message;
    }

    public String getTestEndpointURI() {
        String uri = this.protocol + "://" + USER + ":" + PASSWORD + "@" + LOCALHOST + ":" + this.port + "?connector=" + this.connectorName;
        if (!this.transformInboundMessage()) {
            uri = uri + "&transformers=noActionTransformer";
        }
        return uri;
    }

    protected boolean transformInboundMessage() {
        return false;
    }

    protected void assertMessageOk(Object mailMessage) throws Exception {
        Assert.assertTrue((String)"Did not receive a MimeMessage", (boolean)(mailMessage instanceof MimeMessage));
        MimeMessage received = (MimeMessage)mailMessage;
        Assert.assertTrue((String)"Did not receive a message with String contents", (boolean)(received.getContent() instanceof String));
        String receivedText = ((String)received.getContent()).trim();
        Assert.assertEquals((Object)MESSAGE, (Object)receivedText);
        Address[] recipients = received.getRecipients(Message.RecipientType.TO);
        Assert.assertNotNull((Object)recipients);
        Assert.assertEquals((String)"recipients", (long)1L, (long)recipients.length);
        Assert.assertEquals((String)"recipient", (Object)EMAIL, (Object)recipients[0].toString());
    }

    protected String uniqueName(String root) {
        return root + nameCount.incrementAndGet();
    }
}

