/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.connectors;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.email.connectors.AbstractMailConnectorFunctionalTestCase;
import org.mule.transport.email.transformers.EmailMessageToString;

public abstract class AbstractReceivingMailConnectorTestCase
extends AbstractMailConnectorFunctionalTestCase {
    public static final int POLL_PERIOD_MS = 2000;
    public static final int WAIT_PERIOD_MS = 8000;

    protected AbstractReceivingMailConnectorTestCase(String protocol) {
        super(true, protocol);
    }

    @Test
    public void testReceiver() throws Exception {
        final CountDownLatch countDown = new CountDownLatch(1);
        HashMap<String, 1> props = new HashMap<String, 1>();
        props.put("eventCallback", new EventCallback(){

            public synchronized void eventReceived(MuleEventContext context, Object component) {
                try {
                    AbstractReceivingMailConnectorTestCase.this.logger.debug((Object)"woot - event received");
                    AbstractReceivingMailConnectorTestCase.this.logger.debug((Object)("context: " + context));
                    AbstractReceivingMailConnectorTestCase.this.logger.debug((Object)("component: " + component));
                    AbstractReceivingMailConnectorTestCase.this.assertMessageOk(context.getMessage().getOriginalPayload());
                    countDown.countDown();
                }
                catch (Exception e) {
                    AbstractReceivingMailConnectorTestCase.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
        Service service = MuleTestUtils.getTestService((String)this.uniqueName("testComponent"), FunctionalTestComponent.class, props, (MuleContext)muleContext, (boolean)false);
        EndpointBuilder eb = muleContext.getEndpointFactory().getEndpointBuilder(this.getTestEndpointURI());
        eb.setDisableTransportTransformer(true);
        InboundEndpoint ep = eb.buildInboundEndpoint();
        ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)ep);
        muleContext.getRegistry().registerService(service);
        if (!muleContext.isStarted()) {
            muleContext.start();
        }
        this.logger.debug((Object)"waiting for count down");
        Assert.assertTrue((boolean)countDown.await(8000L, TimeUnit.MILLISECONDS));
    }

    protected static Map newEmailToStringServiceOverrides() {
        HashMap<String, String> serviceOverrides = new HashMap<String, String>();
        serviceOverrides.put("inbound.transformer", EmailMessageToString.class.getName());
        return serviceOverrides;
    }
}

