/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.connectors;

import java.io.OutputStream;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.ResponseOutputStream;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transport.email.AbstractMailConnector;
import org.mule.transport.email.SmtpConnector;
import org.mule.transport.email.connectors.AbstractMailConnectorFunctionalTestCase;

public class SmtpConnectorTestCase
extends AbstractMailConnectorFunctionalTestCase {
    public SmtpConnectorTestCase() {
        this(false, "smtp");
        this.setStartContext(true);
    }

    protected SmtpConnectorTestCase(boolean initialEmail, String protocol) {
        super(initialEmail, protocol);
    }

    public Connector createConnector() throws Exception {
        SmtpConnector c = new SmtpConnector(muleContext);
        c.setName("SmtpConnector");
        return c;
    }

    @Override
    protected boolean transformInboundMessage() {
        return true;
    }

    public void testConnectorListenerSupport() throws Exception {
    }

    @Test
    public void testSmtpDoesNotSupportOutboundEndpoints() throws MuleException {
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(this.getTestEndpointURI(), muleContext);
        builder.setName("test");
        try {
            muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
            Assert.fail((String)"Inbound SMTP endpoints are not supported");
        }
        catch (EndpointException endpointException) {
            // empty catch block
        }
    }

    @Test
    public void testSend() throws Exception {
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint(this.getTestEndpointURI());
        Service service = SmtpConnectorTestCase.getTestService((String)this.uniqueName("testComponent"), FunctionalTestComponent.class);
        OutboundPassThroughRouter passThroughRouter = new OutboundPassThroughRouter();
        passThroughRouter.addRoute((MessageProcessor)endpoint);
        ((OutboundRouterCollection)service.getOutboundMessageProcessor()).addRoute((MatchableMessageProcessor)passThroughRouter);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Email Message", muleContext);
        message.setOutboundProperty("toAddresses", (Object)"bob@example.com");
        MuleSession session = SmtpConnectorTestCase.getTestSession(null, (MuleContext)muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)SmtpConnectorTestCase.getTestService((String)"apple", Apple.class), session, new ResponseOutputStream((OutputStream)System.out));
        endpoint.process((MuleEvent)event);
        this.getServers().waitForIncomingEmail(10000L, 1);
        MimeMessage[] messages = this.getServers().getReceivedMessages();
        Assert.assertNotNull((String)"did not receive any messages", (Object)messages);
        Assert.assertEquals((String)"did not receive 1 mail", (long)1L, (long)messages.length);
        this.assertMessageOk(messages[0]);
    }

    @Test
    public void testConnectorRestart() throws Exception {
        Connector c = this.getConnector();
        Assert.assertTrue((boolean)c.isStarted());
        c.stop();
        Assert.assertFalse((boolean)c.isStarted());
        Assert.assertFalse((boolean)c.isStarted());
        c.start();
        Assert.assertFalse((boolean)c.isDisposed());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testNullUsernameAndPassword() throws Exception {
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint("smtp://localhost:23");
        URLName name = ((AbstractMailConnector)this.getConnector()).urlFromEndpoint((ImmutableEndpoint)endpoint);
        Assert.assertNull((Object)name.getUsername());
        Assert.assertNull((Object)name.getPassword());
        endpoint = muleContext.getEndpointFactory().getOutboundEndpoint("smtp://george@localhost:23");
        name = ((AbstractMailConnector)this.getConnector()).urlFromEndpoint((ImmutableEndpoint)endpoint);
        Assert.assertEquals((Object)"george", (Object)name.getUsername());
        Assert.assertNull((Object)name.getPassword());
    }
}

