/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.functional;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.util.HashMap;
import java.util.Locale;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.junit.Assert;
import org.junit.Rule;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.config.i18n.LocaleMessageHandler;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.email.GreenMailUtilities;
import org.mule.util.SystemUtils;

public abstract class AbstractEmailFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    public static final long DELIVERY_DELAY_MS = 10000L;
    protected static final String CONFIG_BASE = "-functional-test.xml";
    protected static final boolean MIME_MESSAGE = true;
    protected static final boolean STRING_MESSAGE = false;
    protected static final String DEFAULT_EMAIL = "bob@example.com";
    protected static final String DEFAULT_USER = "bob";
    protected static final String DEFAULT_MESSAGE = "Test email message";
    protected static final String DEFAULT_PASSWORD = "password";
    protected static final String DEFAULT_PROCESSED_MAILBOX = "processed";
    private String protocol;
    private boolean isMimeMessage;
    private int port;
    protected GreenMail server;
    private String email;
    private String user;
    private String message;
    private String password;
    private String charset;
    private boolean addAttachments;
    protected ServerSetup setup = null;
    protected ServerSetup smtpSetup = null;
    private int smtpPort;
    private boolean addSmtp = false;
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    protected AbstractEmailFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, boolean isMimeMessage, String protocol) {
        this(variant, isMimeMessage, protocol, protocol + CONFIG_BASE, null, null);
    }

    protected AbstractEmailFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, boolean isMimeMessage, String protocol, Locale locale, String charset) {
        this(variant, isMimeMessage, protocol, protocol + CONFIG_BASE, locale, charset);
    }

    protected AbstractEmailFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, boolean isMimeMessage, String protocol, String configResources) {
        this(variant, isMimeMessage, protocol, configResources, null, null);
    }

    protected AbstractEmailFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, boolean isMimeMessage, String protocol, String configResources, boolean addSmtp) {
        this(variant, isMimeMessage, protocol, configResources, null, null);
        this.addSmtp = addSmtp;
    }

    protected AbstractEmailFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, boolean isMimeMessage, String protocol, String configResources, Locale locale, String charset) {
        this(variant, isMimeMessage, protocol, configResources, DEFAULT_EMAIL, DEFAULT_USER, locale == null ? DEFAULT_MESSAGE : AbstractEmailFunctionalTestCase.getMessage(locale), DEFAULT_PASSWORD, charset);
    }

    protected AbstractEmailFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, boolean isMimeMessage, String protocol, String configResources, String email, String user, String message, String password, String charset) {
        super(variant, configResources);
        this.isMimeMessage = isMimeMessage;
        this.protocol = protocol;
        this.email = email;
        this.user = user;
        this.message = message;
        this.password = password;
        this.charset = charset;
    }

    protected MuleContext createMuleContext() throws Exception {
        this.port = this.dynamicPort1.getNumber();
        this.smtpPort = this.dynamicPort2.getNumber();
        this.startServer();
        this.initDefaultCommandMap();
        return super.createMuleContext();
    }

    private void initDefaultCommandMap() {
        if (SystemUtils.JAVA_VERSION_FLOAT < 1.6f) {
            MailcapCommandMap commandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            commandMap.addMailcap("application/xml;;  x-java-content-handler=com.sun.mail.handlers.text_plain");
            commandMap.addMailcap("application/text;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            CommandMap.setDefaultCommandMap((CommandMap)commandMap);
        }
    }

    public void doTearDown() {
        this.server.stop();
    }

    protected void doSend() throws Exception {
        String msg = this.isMimeMessage ? GreenMailUtilities.toMessage(this.message, this.email, this.charset) : this.message;
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = null;
        if (this.charset != null) {
            props = new HashMap<String, String>();
            props.put("contentType", "text/plain; charset=" + this.charset);
        }
        if (this.addAttachments) {
            DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)msg, props, muleContext);
            this.createOutboundAttachments((MuleMessage)muleMessage);
            client.dispatch("vm://send", (MuleMessage)muleMessage);
        } else {
            client.dispatch("vm://send", (Object)msg, props);
        }
        this.server.waitForIncomingEmail(10000L, 1);
        MimeMessage[] messages = this.server.getReceivedMessages();
        Assert.assertNotNull((String)"did not receive any messages", (Object)messages);
        Assert.assertEquals((String)"did not receive 1 mail", (long)1L, (long)messages.length);
        this.verifyMessage(messages[0]);
    }

    protected void verifyMessage(MimeMessage received) throws Exception {
        if (this.addAttachments) {
            Assert.assertTrue((String)"Did not receive a multipart message", (boolean)(received.getContent() instanceof MimeMultipart));
            this.verifyMessage((MimeMultipart)received.getContent());
        } else {
            Assert.assertTrue((String)"Did not receive a message with String contents", (boolean)(received.getContent() instanceof String));
            this.verifyMessage((String)received.getContent());
        }
        Address[] recipients = received.getRecipients(Message.RecipientType.TO);
        Assert.assertNotNull((Object)recipients);
        Assert.assertEquals((String)"number of recipients", (long)1L, (long)recipients.length);
        Assert.assertEquals((String)"recipient", (Object)this.email, (Object)recipients[0].toString());
    }

    protected void verifyMessage(MimeMultipart mimeMultipart) throws Exception {
        Assert.fail((String)"multipart message was not expected");
    }

    protected void verifyMessage(String receivedText) {
        Assert.assertEquals((Object)this.message, (Object)receivedText.trim());
    }

    protected void doRequest() throws Exception {
        Assert.assertEquals((long)1L, (long)this.server.getReceivedMessages().length);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage reply = client.request("vm://receive", 5000L);
        Assert.assertNotNull((Object)reply);
        Object payload = reply.getPayload();
        if (this.isMimeMessage) {
            Assert.assertTrue((String)("payload is " + payload.getClass().getName()), (boolean)(payload instanceof MimeMessage));
            this.verifyMessage((MimeMessage)payload);
        } else {
            Assert.assertTrue((boolean)(payload instanceof String));
            this.verifyMessage((String)payload);
        }
    }

    private void startServer() throws Exception {
        this.logger.debug((Object)("starting server on port " + this.port));
        this.setup = new ServerSetup(this.port, null, this.protocol);
        if (this.addSmtp) {
            this.smtpSetup = new ServerSetup(this.smtpPort, null, "smtp");
            this.server = new GreenMail(new ServerSetup[]{this.setup, this.smtpSetup});
        } else {
            this.server = new GreenMail(this.setup);
        }
        this.server.getManagers().getUserManager().createUser(this.email, this.user, this.password);
        GreenMailUser gmUser = this.server.getManagers().getUserManager().getUser(this.user);
        assert (null != gmUser);
        this.server.getManagers().getImapHostManager().createMailbox(this.server.getManagers().getUserManager().getUser(DEFAULT_USER), DEFAULT_PROCESSED_MAILBOX);
        this.server.start();
        if (this.protocol.startsWith("pop3") || this.protocol.startsWith("imap")) {
            GreenMailUtilities.storeEmail(this.server.getManagers().getUserManager(), this.email, this.user, this.password, GreenMailUtilities.toMessage(this.message, this.email, this.charset));
        }
        this.logger.debug((Object)("server started for protocol " + this.protocol));
    }

    private void stopServer() {
        this.server.stop();
    }

    private static String getMessage(Locale locale) {
        return LocaleMessageHandler.getString((String)"test-data", (Locale)locale, (String)"AbstractEmailFunctionalTestCase.getMessage", (Object[])new Object[0]);
    }

    public void setAddAttachments(boolean addAttachments) {
        this.addAttachments = addAttachments;
    }

    private void createOutboundAttachments(MuleMessage msg) throws Exception {
        msg.addOutboundAttachment("hello", (Object)"hello", "text/plain");
        msg.addOutboundAttachment("goodbye", (Object)"<a/>", "text/xml");
    }
}

