/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.functional;

import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.user.UserManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.CountdownCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.email.GreenMailUtilities;
import org.mule.transport.email.functional.AbstractEmailFunctionalTestCase;

public class ImapCustomSeenHandlingTestCase
extends AbstractEmailFunctionalTestCase {
    private CountdownCallback messageReceived = new CountdownCallback(1);

    public ImapCustomSeenHandlingTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, false, "imap", configResources);
        this.setStartContext(false);
    }

    protected String getConfigResources() {
        return "imap-custom-seen-flag.xml";
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "imap-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "imap-functional-test-service.xml"});
    }

    @Test
    public void testMessagesMatchingFilterGetCustomFlagSet() throws Exception {
        this.putMailMessageMatchingFilterIntoImapServer();
        this.setupTestComponentListener();
        muleContext.start();
        Assert.assertTrue((boolean)this.messageReceived.await(5000L));
        this.assertMessageIsFlagged();
    }

    private void putMailMessageMatchingFilterIntoImapServer() throws Exception {
        String email = "barney@mule.org";
        UserManager userManager = this.server.getManagers().getUserManager();
        MimeMessage message = GreenMailUtilities.toMessage("Test Message", email, null);
        GreenMailUtilities.storeEmail(userManager, email, "bob", "password", message);
    }

    private void setupTestComponentListener() throws Exception {
        FunctionalTestComponent component = this.getFunctionalTestComponent("custom-flags");
        Assert.assertNotNull((Object)component);
        component.setEventCallback((EventCallback)this.messageReceived);
    }

    private void assertMessageIsFlagged() throws Exception {
        boolean flaggedMessageFound = this.anyMessageIsFlagged();
        Assert.assertTrue((String)"no FLAGGED message found", (boolean)flaggedMessageFound);
    }

    private boolean anyMessageIsFlagged() {
        for (StoredMessage message : this.allImapMessages()) {
            if (!message.getFlags().contains(Flags.Flag.FLAGGED)) continue;
            return true;
        }
        return false;
    }

    private List<StoredMessage> allImapMessages() {
        return this.server.getManagers().getImapHostManager().getAllMessages();
    }
}

