/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.functional;

import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.transport.email.functional.AbstractEmailFunctionalTestCase;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;
import org.mule.util.SystemUtils;

public class ImapFunctionalWithAttachmentsTestCase
extends AbstractEmailFunctionalTestCase {
    private static final String CONFIG_FILE = "email-attachment-save.xml";
    private File saveDir;

    public ImapFunctionalWithAttachmentsTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, true, "imap", configResources, true);
        this.setStartContext(false);
        System.setProperty("mail.user", "bob");
        System.setProperty("mail.password", "password");
        System.setProperty("mail.host", "localhost");
        this.saveDir = new File(SystemUtils.JAVA_IO_TMPDIR, ((Object)((Object)this)).getClass().getName());
        System.setProperty("mail.save.dir", this.saveDir.getAbsolutePath());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, CONFIG_FILE}});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FileUtils.deleteTree((File)new File(System.getProperty("mail.save.dir")));
    }

    @Test
    public void testRequest() throws Exception {
        muleContext.start();
        Assert.assertEquals((long)1L, (long)this.server.getReceivedMessages().length);
        InputStream inputstream = IOUtils.getResourceAsStream((String)CONFIG_FILE, ((Object)((Object)this)).getClass(), (boolean)true, (boolean)false);
        Assert.assertNotNull((Object)inputstream);
        byte[] byteArray = IOUtils.toByteArray((InputStream)inputstream);
        GreenMailUtil.sendAttachmentEmail((String)"bob@example.com", (String)"joe", (String)"email subject with attachments", (String)"", (byte[])byteArray, (String)"text/xml", (String)CONFIG_FILE, (String)"description", (ServerSetup)this.smtpSetup);
        MimeMessage[] messages = this.server.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)messages.length);
        this.assertAttachmentWasSaved();
    }

    private void assertAttachmentWasSaved() {
        PollingProber prober = new PollingProber(10000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                File savedFile = new File(ImapFunctionalWithAttachmentsTestCase.this.saveDir, ImapFunctionalWithAttachmentsTestCase.CONFIG_FILE);
                return savedFile.exists();
            }

            public String describeFailure() {
                return "No attachments were saved";
            }
        });
    }
}

