/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.functional;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.email.GreenMailUtilities;

public class ImapMessageRequesterTestCase
extends FunctionalTestCase {
    private static final String EMAIL = "bob@example.com";
    private static final String MESSAGE = "Test email message";
    private static final String PASSWORD = "password";
    private static int PORT = -1;
    private static final String USER = "bob";
    private GreenMail server;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "imap-message-requester.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        PORT = this.dynamicPort.getNumber();
        this.startGreenmailServer();
    }

    private void startGreenmailServer() throws Exception {
        ServerSetup setup = new ServerSetup(PORT, "localhost", "imap");
        this.server = new GreenMail(setup);
        this.server.start();
        GreenMailUtilities.storeEmail(this.server.getManagers().getUserManager(), EMAIL, USER, PASSWORD, GreenMailUtilities.toMessage(MESSAGE, EMAIL, null));
    }

    protected void doTearDown() throws Exception {
        this.server.stop();
        super.doTearDown();
    }

    @Test
    public void testMessageRequester() throws Exception {
        String imapUri = String.format("imap://%1s:%2s@localhost:%3d/INBOX", USER, PASSWORD, PORT);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.request(imapUri, 5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)MESSAGE, (Object)message.getPayload());
    }
}

