/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.functional;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.transport.AbstractConnector;
import org.mule.transport.email.GreenMailUtilities;
import org.mule.transport.email.functional.AbstractEmailFunctionalTestCase;
import org.mule.transport.email.functional.RetrieveMessageReceiverPollCounter;

public class NonInfiniteMoveToCopiesMule6069TestCase
extends AbstractEmailFunctionalTestCase {
    protected static final String imapConnectorName = "imapConnector";
    private static int numberOfMadePolls;
    protected AbstractConnector imapConnector;
    protected RetrieveMessageReceiverPollCounter receiverPollCounter;

    public NonInfiniteMoveToCopiesMule6069TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, false, "imap", configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "NonInfiniteMoveToCopiesMule6069.xml"}});
    }

    @Test
    public void testRequest() throws Exception {
        this.doRequest();
    }

    @Override
    public void doRequest() throws Exception {
        int expectedMailCount = 4;
        this.imapConnector = (AbstractConnector)muleContext.getRegistry().lookupConnector(imapConnectorName);
        this.addUnreadMail();
        this.receiverPollCounter = (RetrieveMessageReceiverPollCounter)((Object)this.imapConnector.getReceivers().values().iterator().next());
        numberOfMadePolls = this.receiverPollCounter.getNumberOfMadePolls();
        this.waitForPolls();
        Assert.assertEquals((String)"Incorrect amount of mails in mail server using moveToFolder", (long)expectedMailCount, (long)this.server.getReceivedMessages().length);
    }

    private void addUnreadMail() {
        try {
            GreenMailUtilities.storeEmail(this.server.getManagers().getUserManager(), "bob@example.com", "bob", "password", GreenMailUtilities.toMessage("Test email message", "bob@example.com", null));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"Mail could not be added");
        }
    }

    private void waitForPolls() {
        PollingProber prober = new PollingProber(10000L, 100L);
        prober.check(new Probe(){
            private int requiredPollAttempts = NonInfiniteMoveToCopiesMule6069TestCase.access$000() + 3;

            public boolean isSatisfied() {
                return NonInfiniteMoveToCopiesMule6069TestCase.this.receiverPollCounter.pollNumbersGreaterThan(this.requiredPollAttempts);
            }

            public String describeFailure() {
                return "Poller did not poll more than " + this.requiredPollAttempts + "  times";
            }
        });
    }

    static /* synthetic */ int access$000() {
        return numberOfMadePolls;
    }
}

