/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.issues;

import java.io.File;
import org.junit.Assert;
import org.mule.api.transport.Connector;
import org.mule.transport.email.AbstractRetrieveMailConnector;
import org.mule.transport.email.connectors.ImapConnectorTestCase;
import org.mule.util.FileUtils;

public abstract class AbstractBaseBackupMule2050TestCase
extends ImapConnectorTestCase {
    private boolean backupEnabled;

    public AbstractBaseBackupMule2050TestCase(boolean backupEnabled) {
        this.backupEnabled = backupEnabled;
    }

    @Override
    public Connector createConnector() throws Exception {
        Connector connector = super.createConnector();
        ((AbstractRetrieveMailConnector)connector).setBackupEnabled(this.backupEnabled);
        return connector;
    }

    @Override
    public void testReceiver() throws Exception {
        File dir = FileUtils.newFile((String)(muleContext.getConfiguration().getWorkingDirectory() + "/mail/INBOX"));
        FileUtils.deleteTree((File)new File(muleContext.getConfiguration().getWorkingDirectory() + "/mail"));
        Assert.assertFalse((String)("Mail backup file already exists: " + dir.getAbsolutePath()), (boolean)dir.exists());
        this.debug(dir);
        super.testReceiver();
        this.debug(dir);
        Assert.assertTrue((String)dir.getAbsolutePath(), (dir.exists() == this.backupEnabled ? 1 : 0) != 0);
    }

    protected void debug(File dir) {
        this.logger.debug((Object)(dir.getAbsolutePath() + " exists? " + dir.exists()));
    }
}

