/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import java.io.StringReader;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.email.GreenMailUtilities;
import org.mule.transport.email.transformers.EmailMessageToString;

public class EmailMessageToStringTestCase
extends AbstractMuleTestCase {
    private EmailMessageToString transformer;
    private static String TEXT = "text";
    private static String TO = "me@me.com";

    @Before
    public void createTransformer() {
        this.transformer = new EmailMessageToString();
    }

    @Test
    public void testSimpleStringMessage() throws MessagingException, TransformerException {
        MimeMessage msg = GreenMailUtilities.toMessage(TEXT, TO, null);
        Assert.assertEquals((Object)TEXT, (Object)this.transformer.transform((Object)msg));
    }

    @Test
    public void testSimpleNonTextMessage() throws MessagingException, TransformerException {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setContent((Object)new StringReader(TEXT), "application/octet-stream");
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(TO));
        Assert.assertEquals((Object)"", (Object)this.transformer.transform((Object)message));
    }

    @Test
    public void testMultipartFirstPartTextMessage() throws MessagingException, TransformerException {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart bp1 = new MimeBodyPart();
        bp1.setContent((Object)TEXT, "test/plain");
        mimeMultipart.addBodyPart((BodyPart)bp1);
        message.setContent((Multipart)mimeMultipart);
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(TO));
        Assert.assertEquals((Object)TEXT, (Object)this.transformer.transform((Object)message));
    }

    @Test
    public void testMultipartMessage2() throws MessagingException, TransformerException {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart bp1 = new MimeBodyPart();
        bp1.setContent((Object)new StringReader(TEXT), "binary");
        mimeMultipart.addBodyPart((BodyPart)bp1);
        message.setContent((Multipart)mimeMultipart);
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(TO));
        Assert.assertEquals((Object)"", (Object)this.transformer.transform((Object)message));
    }
}

