/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.email.transformers.EmailMessageToString;
import org.mule.transport.email.transformers.StringToEmailMessage;

public class MailMessageTransformersTestCase
extends AbstractTransformerTestCase {
    private Message message;

    public Transformer getTransformer() throws Exception {
        return (Transformer)this.createObject(EmailMessageToString.class);
    }

    public Transformer getRoundTripTransformer() throws Exception {
        StringToEmailMessage trans = (StringToEmailMessage)this.createObject(StringToEmailMessage.class);
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint("smtp://a:a@a.com");
        try {
            endpoint.getConnector().initialise();
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e);
        }
        trans.setEndpoint((ImmutableEndpoint)endpoint);
        return trans;
    }

    public Object getTestData() {
        if (this.message == null) {
            this.message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
            try {
                this.message.setContent(this.getResultData(), this.getContentType());
            }
            catch (MessagingException e) {
                throw new RuntimeException("Failed to create Mime Message: " + e.getMessage(), e);
            }
        }
        return this.message;
    }

    protected String getContentType() {
        return "text/plain";
    }

    public Object getResultData() {
        return "Test Email Message";
    }

    public boolean compareResults(Object src, Object result) {
        if (src instanceof Message) {
            Object objRes;
            Object objSrc;
            try {
                objSrc = ((Message)src).getContent();
                objRes = ((Message)result).getContent();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (objSrc == null || objRes == null) {
                return false;
            }
            return objRes.equals(objSrc);
        }
        return super.compareResults(src, result);
    }

    @Test
    public void testStringSourceType() throws Exception {
        try {
            Assert.assertFalse((boolean)this.getTransformer().isSourceDataTypeSupported(DataTypeFactory.STRING));
            this.getTransformer().transform(this.getResultData());
            Assert.fail((String)"Should throw exception for string source type");
        }
        catch (TransformerException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testStringSourceTypeWithIgnoreBadInput() throws Exception {
        AbstractTransformer trans = (AbstractTransformer)this.getTransformer();
        trans.setIgnoreBadInput(true);
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setUseExtendedTransformations(false);
        Object result = trans.transform(this.getResultData());
        trans.setIgnoreBadInput(false);
        Assert.assertEquals((Object)result, (Object)this.getResultData());
    }
}

