/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import java.io.IOException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.email.transformers.MimeMessageToRfc822ByteArray;
import org.mule.transport.email.transformers.Rfc822ByteArraytoMimeMessage;

public class Rfc822ByteArrayTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "rfc822-byte-array-test.xml";
    }

    @Test
    public void testToByteArray() throws MessagingException, TransformerException {
        this.mimeMessageToByteArray(this.newMimeMessage());
    }

    @Test
    public void testToByteArrayAndBack() throws MessagingException, MuleException, IOException {
        MimeMessage first = this.newMimeMessage();
        byte[] bytes = this.mimeMessageToByteArray(first);
        MimeMessage second = this.byteArrayToMimeMessage(bytes);
        Assert.assertEquals((Object)first.getSubject(), (Object)second.getSubject());
        Assert.assertEquals((Object)first.getContent(), (Object)second.getContent());
        Assert.assertEquals((long)1L, (long)second.getFrom().length);
        Assert.assertEquals((long)first.getFrom().length, (long)second.getFrom().length);
        Assert.assertEquals((Object)first.getFrom()[0], (Object)second.getFrom()[0]);
    }

    protected MimeMessage byteArrayToMimeMessage(byte[] bytes) throws MuleException {
        Rfc822ByteArraytoMimeMessage transformer = new Rfc822ByteArraytoMimeMessage();
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint("smtp");
        transformer.setEndpoint((ImmutableEndpoint)endpoint);
        Object result = transformer.transform((Object)bytes);
        Assert.assertTrue((boolean)(result instanceof MimeMessage));
        return (MimeMessage)result;
    }

    protected byte[] mimeMessageToByteArray(MimeMessage mimeMessage) throws TransformerException {
        Object result = new MimeMessageToRfc822ByteArray().transform((Object)mimeMessage);
        Assert.assertTrue((boolean)(result instanceof byte[]));
        return (byte[])result;
    }

    protected MimeMessage newMimeMessage() throws MessagingException {
        MimeMessage message = new MimeMessage(this.newSession());
        message.setText("text");
        message.setSubject("text");
        message.setFrom((Address)new InternetAddress("bob@example.com"));
        return message;
    }

    protected Session newSession() {
        return Session.getDefaultInstance((Properties)new Properties(), null);
    }
}

