/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.activation.MimeType;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.email.functional.AbstractEmailFunctionalTestCase;

public class SmtpAttachmentsFunctionalInboundAttachmentsOnlyTestCase
extends AbstractEmailFunctionalTestCase {
    public SmtpAttachmentsFunctionalInboundAttachmentsOnlyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, false, "smtp", configResources);
        this.setAddAttachments(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "smtp-functional-test-inbound-attachments-only-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "smtp-functional-test-inbound-attachments-only-flow.xml"});
    }

    @Test
    public void testSend() throws Exception {
        this.doSend();
    }

    @Override
    protected void verifyMessage(MimeMultipart content) throws Exception {
        Assert.assertEquals((long)3L, (long)content.getCount());
        this.verifyMessage((String)content.getBodyPart(0).getContent());
        List<String> expectedTypes = Arrays.asList("text/plain", "text/xml");
        for (int i = 0; i < 3; ++i) {
            BodyPart part = content.getBodyPart(i);
            String type = part.getContentType();
            MimeType mt = new MimeType(type);
            Assert.assertTrue((boolean)expectedTypes.contains(mt.getPrimaryType() + "/" + mt.getSubType()));
        }
    }
}

