/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.activation.MimeType;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.email.functional.AbstractEmailFunctionalTestCase;

public class SmtpAttachmentsFunctionalTestCase
extends AbstractEmailFunctionalTestCase {
    public SmtpAttachmentsFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, false, "smtp", configResources);
        this.setAddAttachments(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "smtp-functional-test-all-attachments-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "smtp-functional-test-all-attachments-service.xml"});
    }

    @Test
    public void testSend() throws Exception {
        this.doSend();
    }

    @Override
    protected void verifyMessage(MimeMultipart content) throws Exception {
        Assert.assertEquals((long)4L, (long)content.getCount());
        this.verifyMessage((String)content.getBodyPart(0).getContent());
        List<String> expectedTypes = Arrays.asList("text/plain", "application/xml", "application/text");
        for (int i = 1; i < 4; ++i) {
            BodyPart part = content.getBodyPart(i);
            String type = part.getContentType();
            MimeType mt = new MimeType(type);
            Assert.assertTrue((boolean)expectedTypes.contains(mt.getPrimaryType() + "/" + mt.getSubType()));
        }
    }
}

