/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.file.FileConnector;
import org.mule.providers.file.filters.FilenameWildcardFilter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.FileUtils;
import org.mule.util.MapUtils;

public class FileMessageDispatcher
extends AbstractMessageDispatcher {
    private FileConnector connector;

    public FileMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (FileConnector)endpoint.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(UMOEvent event) throws Exception {
        Object data = event.getTransformedMessage();
        MuleMessage message = new MuleMessage(data, (UMOMessageAdapter)event.getMessage());
        byte[] buf = data instanceof byte[] ? (byte[])data : data.toString().getBytes(event.getEncoding());
        FileOutputStream fos = (FileOutputStream)this.getOutputStream(event.getEndpoint(), (UMOMessage)message);
        try {
            fos.write(buf);
        }
        finally {
            fos.close();
        }
    }

    public OutputStream getOutputStream(UMOImmutableEndpoint endpoint, UMOMessage message) throws UMOException {
        String address = endpoint.getEndpointURI().getAddress();
        String filename = message.getStringProperty("filename", null);
        try {
            if (filename == null) {
                String outPattern = message.getStringProperty("outputPattern", null);
                if (outPattern == null) {
                    outPattern = this.connector.getOutputPattern();
                }
                filename = this.generateFilename(message, outPattern);
            }
            if (filename == null) {
                throw new IOException("Filename is null");
            }
            File file = FileUtils.createFile((String)(address + "/" + filename));
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Writing file to: " + file.getAbsolutePath()));
            }
            return new FileOutputStream(file, MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"outputAppend", (boolean)this.connector.isOutputAppend()));
        }
        catch (IOException e) {
            throw new DispatchException(new Message(205), message, endpoint, (Throwable)e);
        }
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        File file = new File(endpoint.getEndpointURI().getAddress());
        File result = null;
        FilenameWildcardFilter filenameFilter = null;
        String filter = (String)endpoint.getProperty((Object)"filter");
        if (filter != null) {
            filter = URLDecoder.decode(filter, MuleManager.getConfiguration().getEncoding());
            filenameFilter = new FilenameWildcardFilter(filter);
        }
        if (file.exists()) {
            if (file.isFile()) {
                result = file;
            } else if (file.isDirectory()) {
                result = this.getNextFile(endpoint.getEndpointURI().getAddress(), filenameFilter);
            }
            if (result != null) {
                File destinationFile;
                boolean checkFileAge = this.connector.getCheckFileAge();
                if (checkFileAge) {
                    long fileAge = this.connector.getFileAge();
                    long lastMod = result.lastModified();
                    long now = new Date().getTime();
                    if (now - lastMod < fileAge) {
                        return null;
                    }
                }
                MuleMessage message = new MuleMessage((Object)this.connector.getMessageAdapter(result));
                if (this.connector.getMoveToDirectory() != null && !result.renameTo(destinationFile = new File(this.connector.getMoveToDirectory(), result.getName()))) {
                    this.logger.error((Object)("Failed to move file: " + result.getAbsolutePath() + " to " + destinationFile.getAbsolutePath()));
                }
                result.delete();
                return message;
            }
        }
        return null;
    }

    private File getNextFile(String dir, FilenameFilter filter) throws UMOException {
        File[] files = new File[]{};
        File file = new File(dir);
        File result = null;
        try {
            if (file.exists()) {
                if (file.isFile()) {
                    result = file;
                } else if (file.isDirectory() && (files = filter != null ? file.listFiles(filter) : file.listFiles()).length > 0) {
                    result = files[0];
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleException(new Message("file", 1), (Throwable)e);
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    private String generateFilename(UMOMessage message, String pattern) {
        if (pattern == null) {
            pattern = this.connector.getOutputPattern();
        }
        return this.connector.getFilenameParser().getFilename((UMOMessageAdapter)message, pattern);
    }

    protected void doDispose() {
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

