/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.mule.providers.file.FilenameParser;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.DateUtils;
import org.mule.util.UUID;

public class SimpleFilenameParser
implements FilenameParser {
    public static final String DEFAULT_DATE_FORMAT = "dd-MM-yy_HH-mm-ss.SS";
    private AtomicLong count = new AtomicLong(0L);

    public String getFilename(UMOMessageAdapter adapter, String pattern) {
        String result = null;
        result = pattern != null && pattern.indexOf(123) > -1 ? this.getFilename(adapter, pattern, '{', '}') : this.getFilename(adapter, pattern, '[', ']');
        return result;
    }

    protected String getFilename(UMOMessageAdapter adapter, String pattern, char left, char right) {
        String filename = pattern;
        if (pattern == null) {
            filename = System.currentTimeMillis() + ".dat";
        } else {
            String name;
            int index = pattern.indexOf("$" + left + "DATE" + right);
            if (index > -1) {
                filename = filename.replaceAll("\\$\\" + left + "DATE\\" + right, DateUtils.getTimeStamp((String)DEFAULT_DATE_FORMAT));
            }
            if ((index = pattern.indexOf("$" + left + "DATE:")) > -1) {
                int curl = pattern.indexOf(right, index);
                if (curl == -1) {
                    filename = filename.replaceAll("\\$\\" + left + "DATE:", DateUtils.getTimeStamp((String)DEFAULT_DATE_FORMAT));
                } else {
                    String dateformat = pattern.substring(index + 7, curl);
                    filename = filename.replaceAll("\\$\\" + left + "DATE:" + dateformat + "\\" + right, DateUtils.getTimeStamp((String)dateformat));
                }
            }
            if ((index = pattern.indexOf("$" + left + "UUID" + right)) > -1) {
                filename = filename.replaceAll("\\$\\" + left + "UUID\\" + right, UUID.getUUID());
            }
            if ((index = pattern.indexOf("$" + left + "SYSTIME" + right)) > -1) {
                filename = filename.replaceAll("\\$\\" + left + "SYSTIME\\" + right, String.valueOf(System.currentTimeMillis()));
            }
            if ((index = pattern.indexOf("$" + left + "COUNT" + right)) > -1) {
                filename = filename.replaceAll("\\$\\" + left + "COUNT\\" + right, String.valueOf(this.count.getAndIncrement()));
            }
            if ((index = pattern.indexOf("$" + left + "ORIGINALNAME" + right)) > -1 && adapter != null && (name = (String)adapter.getProperty("originalFilename")) != null) {
                filename = filename.replaceAll("\\$\\" + left + "ORIGINALNAME\\" + right, name);
            }
        }
        return filename;
    }
}

