/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.file.FileMessageAdapter;
import org.mule.providers.file.FilenameParser;
import org.mule.providers.file.SimpleFilenameParser;
import org.mule.providers.file.filters.FilenameWildcardFilter;
import org.mule.transformers.simple.ByteArrayToSerializable;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.FileUtils;

public class FileConnector
extends AbstractServiceEnabledConnector {
    private static Log logger = LogFactory.getLog((Class)FileConnector.class);
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    public static final String PROPERTY_FILE_AGE = "fileAge";
    public static final String PROPERTY_FILENAME = "filename";
    public static final String PROPERTY_ORIGINAL_FILENAME = "originalFilename";
    public static final String PROPERTY_OUTPUT_PATTERN = "outputPattern";
    public static final String PROPERTY_MOVE_TO_PATTERN = "moveToPattern";
    public static final String PROPERTY_MOVE_TO_DIRECTORY = "moveToDirectory";
    public static final String PROPERTY_DELETE_ON_READ = "autoDelete";
    public static final String PROPERTY_DIRECTORY = "directory";
    public static final long DEFAULT_POLLING_FREQUENCY = 1000L;
    private long pollingFrequency = 0L;
    private String moveToPattern = null;
    private String writeToDirectoryName = null;
    private String moveToDirectoryName = null;
    private String outputPattern = null;
    private boolean outputAppend = false;
    private boolean autoDelete = true;
    private boolean checkFileAge = false;
    private long fileAge = 0L;
    private FileOutputStream outputStream = null;
    private boolean serialiseObjects = false;
    public FilenameParser filenameParser = new SimpleFilenameParser();

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        if (endpoint.getFilter() != null) {
            return endpoint.getEndpointURI().getAddress() + "/" + ((FilenameWildcardFilter)endpoint.getFilter()).getPattern();
        }
        return endpoint.getEndpointURI().getAddress();
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        String readDir = endpoint.getEndpointURI().getAddress();
        long polling = this.pollingFrequency;
        String moveTo = this.moveToDirectoryName;
        String moveToPattern = this.getMoveToPattern();
        Map props = endpoint.getProperties();
        if (props != null) {
            String tempFileAge;
            String tempPolling;
            String tempMoveToPattern;
            String move = (String)props.get(PROPERTY_MOVE_TO_DIRECTORY);
            if (move != null) {
                moveTo = move;
            }
            if ((tempMoveToPattern = (String)props.get(PROPERTY_MOVE_TO_PATTERN)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("set moveTo Pattern to: " + tempMoveToPattern));
                }
                moveToPattern = tempMoveToPattern;
            }
            if ((tempPolling = (String)props.get(PROPERTY_POLLING_FREQUENCY)) != null) {
                polling = Long.parseLong(tempPolling);
            }
            if (polling <= 0L) {
                polling = 1000L;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set polling frequency to: " + polling));
            }
            if ((tempFileAge = (String)props.get(PROPERTY_FILE_AGE)) != null) {
                try {
                    this.setFileAge(Long.parseLong(tempFileAge));
                }
                catch (Exception ex1) {
                    logger.error((Object)"Failed to set fileAge", (Throwable)ex1);
                }
            }
        }
        try {
            return this.serviceDescriptor.createMessageReceiver((UMOConnector)this, component, endpoint, new Object[]{readDir, moveTo, moveToPattern, new Long(polling)});
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(74, (Object)"Message Receiver", (Object)this.serviceDescriptor.getMessageReceiver()), (Throwable)e, (Object)this);
        }
    }

    protected synchronized void doStop() throws UMOException {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to close file output stream on stop: " + e));
            }
        }
    }

    public String getProtocol() {
        return "file";
    }

    public FilenameParser getFilenameParser() {
        return this.filenameParser;
    }

    public void setFilenameParser(FilenameParser filenameParser) {
        this.filenameParser = filenameParser;
    }

    protected void doDispose() {
        try {
            this.doStop();
        }
        catch (UMOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getMoveToDirectory() {
        return this.moveToDirectoryName;
    }

    public void setMoveToDirectory(String dir) {
        this.moveToDirectoryName = dir;
    }

    public boolean isOutputAppend() {
        return this.outputAppend;
    }

    public void setOutputAppend(boolean outputAppend) {
        this.outputAppend = outputAppend;
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public FileOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(FileOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public long getFileAge() {
        return this.fileAge;
    }

    public boolean getCheckFileAge() {
        return this.checkFileAge;
    }

    public void setFileAge(long fileAge) {
        this.fileAge = fileAge;
        this.checkFileAge = true;
    }

    public String getWriteToDirectory() {
        return this.writeToDirectoryName;
    }

    public void setWriteToDirectory(String dir) throws IOException {
        File writeToDirectory;
        this.writeToDirectoryName = dir;
        if (!(this.writeToDirectoryName == null || (writeToDirectory = FileUtils.openDirectory((String)this.writeToDirectoryName)).canRead() && writeToDirectory.canWrite())) {
            throw new IOException("Error on initialization, Write To directory does not exist or is not read/write");
        }
    }

    public boolean isSerialiseObjects() {
        return this.serialiseObjects;
    }

    public void setSerialiseObjects(boolean serialiseObjects) {
        if (serialiseObjects) {
            if (this.serviceOverrides == null) {
                this.serviceOverrides = new Properties();
            }
            this.serviceOverrides.setProperty("inbound.transformer", ByteArrayToSerializable.class.getName());
            this.serviceOverrides.setProperty("outbound.transformer", SerializableToByteArray.class.getName());
        }
        this.serialiseObjects = serialiseObjects;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
        if (!autoDelete) {
            if (this.serviceOverrides == null) {
                this.serviceOverrides = new Properties();
            }
            if (this.serviceOverrides.getProperty("message.adapter") == null) {
                this.serviceOverrides.setProperty("message.adapter", FileMessageAdapter.class.getName());
            }
        }
    }

    public String getMoveToPattern() {
        return this.moveToPattern;
    }

    public void setMoveToPattern(String moveToPattern) {
        this.moveToPattern = moveToPattern;
    }
}

