/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.ConnectException;
import org.mule.providers.PollingMessageReceiver;
import org.mule.providers.file.FileConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.routing.RoutingException;
import org.mule.util.FileUtils;

public class FileMessageReceiver
extends PollingMessageReceiver {
    private String readDir = null;
    private String moveDir = null;
    private File readDirectory = null;
    private File moveDirectory = null;
    private String moveToPattern = null;
    private FilenameFilter filenameFilter = null;

    public FileMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, String readDir, String moveDir, String moveToPattern, Long frequency) throws InitialisationException {
        super(connector, component, endpoint, frequency);
        this.readDir = readDir;
        this.moveDir = moveDir;
        this.moveToPattern = moveToPattern;
        if (endpoint.getFilter() instanceof FilenameFilter) {
            this.filenameFilter = (FilenameFilter)endpoint.getFilter();
        }
    }

    public void doConnect() throws Exception {
        if (this.readDir != null) {
            this.readDirectory = FileUtils.openDirectory((String)this.readDir);
            if (!this.readDirectory.canRead()) {
                throw new ConnectException(new Message(149, (Object)this.readDirectory.getAbsolutePath()), (Object)this);
            }
            this.logger.debug((Object)("Listening on endpointUri: " + this.readDirectory.getAbsolutePath()));
        }
        if (this.moveDir != null) {
            this.moveDirectory = FileUtils.openDirectory((String)this.moveDir);
            if (!this.moveDirectory.canRead() || !this.moveDirectory.canWrite()) {
                throw new ConnectException(new Message("file", 5), (Object)this);
            }
        }
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() {
        try {
            File[] files = this.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.processFile(files[i]);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void processFile(File sourceFile) throws UMOException {
        boolean checkFileAge = ((FileConnector)this.connector).getCheckFileAge();
        if (checkFileAge) {
            long fileAge = ((FileConnector)this.connector).getFileAge();
            long lastMod = sourceFile.lastModified();
            long now = new Date().getTime();
            if (now - lastMod < fileAge) {
                return;
            }
        }
        File destinationFile = null;
        String sourceFileOriginalName = sourceFile.getName();
        UMOMessageAdapter msgAdapter = this.connector.getMessageAdapter((Object)sourceFile);
        msgAdapter.setProperty("originalFilename", (Object)sourceFileOriginalName);
        if (this.moveDir != null) {
            String destinationFileName = sourceFileOriginalName;
            if (this.moveToPattern != null) {
                destinationFileName = ((FileConnector)this.connector).getFilenameParser().getFilename(msgAdapter, this.moveToPattern);
            }
            destinationFile = new File(this.moveDir, destinationFileName);
        }
        boolean fileWasMoved = false;
        try {
            if (!(sourceFile.canRead() && sourceFile.exists() && sourceFile.isFile())) {
                throw new MuleException(new Message(149, (Object)sourceFileOriginalName));
            }
            if (destinationFile != null) {
                fileWasMoved = this.moveFile(sourceFile, destinationFile);
                if (!fileWasMoved) {
                    throw new MuleException(new Message("file", 4, (Object)sourceFile.getAbsolutePath(), (Object)destinationFile.getAbsolutePath()));
                }
                msgAdapter = this.connector.getMessageAdapter((Object)destinationFile);
                msgAdapter.setProperty("filename", (Object)destinationFile.getName());
                msgAdapter.setProperty("originalFilename", (Object)sourceFileOriginalName);
            }
            if (((FileConnector)this.connector).isAutoDelete() && destinationFile == null && !sourceFile.delete()) {
                throw new MuleException(new Message("file", 3, (Object)sourceFile.getAbsolutePath()));
            }
            this.routeMessage((UMOMessage)new MuleMessage((Object)msgAdapter), this.endpoint.isSynchronous());
        }
        catch (Exception e) {
            boolean fileWasRolledBack = false;
            if (fileWasMoved) {
                fileWasRolledBack = this.rollbackFileMove(destinationFile, sourceFile.getAbsolutePath());
            }
            RoutingException ex = new RoutingException(new Message("file", 2, (Object)sourceFile.getName(), (Object)(fileWasRolledBack ? "successful" : "unsuccessful")), (UMOMessage)new MuleMessage((Object)msgAdapter), (UMOImmutableEndpoint)this.endpoint, (Throwable)e);
            this.handleException((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean moveFile(File sourceFile, File destinationFile) {
        boolean success = sourceFile.renameTo(destinationFile);
        if (!success) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(sourceFile);
                fos = new FileOutputStream(destinationFile);
                FileChannel srcChannel = fis.getChannel();
                FileChannel dstChannel = fos.getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                success = sourceFile.delete();
            }
            catch (IOException ioex) {
                try {
                    success = false;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
                IOUtils.closeQuietly(fos);
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        return success;
    }

    protected boolean rollbackFileMove(File sourceFile, String destinationFilePath) {
        boolean result = false;
        try {
            result = this.moveFile(sourceFile, FileUtils.newFile((String)destinationFilePath));
        }
        catch (Throwable t) {
            this.logger.debug((Object)("rollback of file move failed: " + t.getMessage()));
        }
        return result;
    }

    File[] listFiles() throws MuleException {
        try {
            File[] todoFiles = this.readDirectory.listFiles(this.filenameFilter);
            return todoFiles == null ? new File[]{} : todoFiles;
        }
        catch (Exception e) {
            throw new MuleException(new Message("file", 1), (Throwable)e);
        }
    }
}

