/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import org.apache.commons.lang.ObjectUtils;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.file.transformers.FileToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;

public class FileMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -7537351654335754190L;
    private FileToByteArray transformer = new FileToByteArray();
    private File file = null;
    private byte[] contents = null;

    public FileMessageAdapter(Object message) throws MessagingException {
        if (!(message instanceof File)) {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
        this.setMessage((File)message);
    }

    public Object getPayload() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPayloadAsBytes() throws Exception {
        FileMessageAdapter fileMessageAdapter = this;
        synchronized (fileMessageAdapter) {
            if (this.contents == null) {
                try {
                    this.contents = (byte[])this.transformer.transform(this.file);
                }
                catch (Exception noPayloadException) {
                    throw new MuleException(new Message(124), (Throwable)noPayloadException);
                }
            }
            return this.contents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPayloadAsString(String encoding) throws Exception {
        FileMessageAdapter fileMessageAdapter = this;
        synchronized (fileMessageAdapter) {
            return new String(this.getPayloadAsBytes(), encoding);
        }
    }

    protected void setMessage(File message) throws MessagingException {
        Exception fileInvalidException;
        boolean fileIsValid;
        try {
            fileIsValid = message != null && message.isFile();
            fileInvalidException = null;
        }
        catch (Exception ex) {
            fileInvalidException = ex;
            fileIsValid = false;
        }
        if (!fileIsValid) {
            Object exceptionArg = fileInvalidException != null ? fileInvalidException : ObjectUtils.toString((Object)message, (String)"null");
            Message msg = new Message(149, (Object)ObjectUtils.toString((Object)message, (String)"null"));
            throw new MessagingException(msg, exceptionArg);
        }
        this.file = message;
        this.contents = null;
        this.setProperty("originalFilename", this.file.getName());
        this.setProperty("directory", this.file.getParent());
    }

    public String getUniqueId() {
        return this.file.getAbsolutePath();
    }
}

