/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file.transformers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class FileToByteArray
extends AbstractTransformer {
    private static final long serialVersionUID = -2836878450595052607L;

    public FileToByteArray() {
        this.registerSourceType(File.class);
        this.setReturnClass([B.class);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] byArray;
        File file = (File)src;
        if (file == null) {
            throw new TransformerException((UMOTransformer)this, (Throwable)new IllegalArgumentException("null file"));
        }
        if (!file.exists()) {
            throw new TransformerException((UMOTransformer)this, (Throwable)new FileNotFoundException(file.getPath()));
        }
        if (file.length() == 0L) {
            this.logger.warn((Object)("File is empty: " + file.getAbsolutePath()));
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        FileInputStream fis = null;
        byte[] bytes = null;
        try {
            fis = new FileInputStream(file);
            int length = new Long(file.length()).intValue();
            bytes = new byte[length];
            fis.read(bytes);
            byArray = bytes;
        }
        catch (OutOfMemoryError oom) {
            try {
                throw new TransformerException((UMOTransformer)this, (Throwable)oom);
                catch (IOException e) {
                    throw new TransformerException((UMOTransformer)this, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return byArray;
    }
}

