/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.net.URLDecoder;
import java.util.Date;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.file.FileConnector;
import org.mule.providers.file.filters.FilenameWildcardFilter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.FileUtils;

public class FileMessageDispatcher
extends AbstractMessageDispatcher {
    private final FileConnector connector;

    public FileMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (FileConnector)endpoint.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(UMOEvent event) throws Exception {
        Object data = event.getTransformedMessage();
        MuleMessage message = new MuleMessage(data, (UMOMessageAdapter)event.getMessage());
        byte[] buf = data instanceof byte[] ? (byte[])data : data.toString().getBytes(event.getEncoding());
        FileOutputStream fos = (FileOutputStream)this.connector.getOutputStream(event.getEndpoint(), (UMOMessage)message);
        if (event.getMessage().getStringProperty("filename", null) == null) {
            event.getMessage().setStringProperty("filename", message.getStringProperty("filename", ""));
        }
        try {
            fos.write(buf);
        }
        finally {
            fos.close();
        }
    }

    protected UMOMessage doReceive(long timeout) throws Exception {
        File file = FileUtils.newFile((String)this.endpoint.getEndpointURI().getAddress());
        File result = null;
        FilenameWildcardFilter filenameFilter = null;
        String filter = (String)this.endpoint.getProperty((Object)"filter");
        if (filter != null) {
            filter = URLDecoder.decode(filter, MuleManager.getConfiguration().getEncoding());
            filenameFilter = new FilenameWildcardFilter(filter);
        }
        if (file.exists()) {
            if (file.isFile()) {
                result = file;
            } else if (file.isDirectory()) {
                result = this.getNextFile(this.endpoint.getEndpointURI().getAddress(), filenameFilter);
            }
            if (result != null) {
                File destinationFile;
                boolean checkFileAge = this.connector.getCheckFileAge();
                if (checkFileAge) {
                    long fileAge = this.connector.getFileAge();
                    long lastMod = result.lastModified();
                    long now = new Date().getTime();
                    if (now - lastMod < fileAge) {
                        return null;
                    }
                }
                MuleMessage message = new MuleMessage((Object)this.connector.getMessageAdapter(result));
                if (this.connector.getMoveToDirectory() != null && !result.renameTo(destinationFile = new File(this.connector.getMoveToDirectory(), result.getName()))) {
                    this.logger.error((Object)("Failed to move file: " + result.getAbsolutePath() + " to " + destinationFile.getAbsolutePath()));
                }
                result.delete();
                return message;
            }
        }
        return null;
    }

    private File getNextFile(String dir, FilenameFilter filter) throws UMOException {
        File file = FileUtils.newFile((String)dir);
        File result = null;
        try {
            if (file.exists()) {
                File[] files;
                if (file.isFile()) {
                    result = file;
                } else if (file.isDirectory() && (files = filter != null ? file.listFiles(filter) : file.listFiles()).length > 0) {
                    result = files[0];
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleException(new Message("file", 1), (Throwable)e);
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

