/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.mule.providers.file.FilenameParser;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.DateUtils;
import org.mule.util.TemplateParser;
import org.mule.util.UUID;

public class SimpleFilenameParser
implements FilenameParser {
    public static final String DEFAULT_DATE_FORMAT = "dd-MM-yy_HH-mm-ss.SSS";
    private final TemplateParser antParser = TemplateParser.createAntStyleParser();
    private final TemplateParser squareParser = TemplateParser.createSquareBracesStyleParser();
    private final AtomicLong count = new AtomicLong(0L);

    public String getFilename(UMOMessageAdapter adapter, String pattern) {
        if (pattern == null) {
            return UUID.getUUID() + ".dat";
        }
        if (pattern.indexOf(123) > -1) {
            return this.getFilename(adapter, pattern, this.antParser);
        }
        return this.getFilename(adapter, pattern, this.squareParser);
    }

    protected String getFilename(final UMOMessageAdapter adapter, String pattern, TemplateParser parser) {
        return parser.parse(new TemplateParser.TemplateCallback(){

            public Object match(String token) {
                if (token.equals("DATE")) {
                    return DateUtils.getTimeStamp((String)SimpleFilenameParser.DEFAULT_DATE_FORMAT);
                }
                if (token.startsWith("DATE:")) {
                    token = token.substring(5);
                    return DateUtils.getTimeStamp((String)token);
                }
                if (token.startsWith("UUID")) {
                    return UUID.getUUID();
                }
                if (token.startsWith("SYSTIME")) {
                    return String.valueOf(System.currentTimeMillis());
                }
                if (token.startsWith("COUNT")) {
                    return String.valueOf(SimpleFilenameParser.this.count.getAndIncrement());
                }
                if (adapter != null) {
                    if (token.startsWith("ORIGINALNAME")) {
                        return adapter.getStringProperty("originalFilename", null);
                    }
                    return adapter.getStringProperty(token, null);
                }
                return null;
            }
        }, pattern);
    }
}

