/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import org.mule.providers.file.FileConnector;
import org.mule.tck.FunctionalTestCase;
import org.mule.umo.UMOMessage;

public abstract class AbstractFileFunctionalTestCase
extends FunctionalTestCase {
    public static final String TEST_MESSAGE = "Test file contents";
    public static final String TARGET_FILE = "TARGET_FILE";

    public AbstractFileFunctionalTestCase() {
        this.setDisposeManagerPerSuite(true);
    }

    protected String getConfigResources() {
        return "file-functional-test.xml";
    }

    protected String fileToUrl(File file) throws MalformedURLException {
        return file.getAbsoluteFile().toURI().toURL().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForFileSystem() throws Exception {
        AbstractFileFunctionalTestCase abstractFileFunctionalTestCase = this;
        synchronized (abstractFileFunctionalTestCase) {
            ((Object)((Object)this)).wait(1000L);
        }
    }

    protected File initForReceive() throws Exception {
        File tmpDir = File.createTempFile("mule-file-test-", "-dir");
        tmpDir.delete();
        tmpDir.mkdir();
        tmpDir.deleteOnExit();
        File target = File.createTempFile("mule-file-test-", ".txt", tmpDir);
        FileWriter out = new FileWriter(target);
        out.write(TEST_MESSAGE);
        ((Writer)out).close();
        target.deleteOnExit();
        FileConnector connector = (FileConnector)managementContext.getRegistry().lookupConnector("receiveConnector");
        connector.setReadFromDirectory(tmpDir.getAbsolutePath());
        this.logger.debug((Object)("Directory is " + connector.getReadFromDirectory()));
        this.waitForFileSystem();
        return target;
    }

    protected void checkReceivedMessage(UMOMessage message) throws Exception {
        AbstractFileFunctionalTestCase.assertNotNull((Object)message);
        AbstractFileFunctionalTestCase.assertNotNull((Object)message.getPayload());
        AbstractFileFunctionalTestCase.assertTrue((boolean)(message.getPayload() instanceof byte[]));
        String result = new String((byte[])message.getPayload());
        AbstractFileFunctionalTestCase.assertEquals((String)TEST_MESSAGE, (String)result);
    }
}

