/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import org.mule.RegistryContext;
import org.mule.impl.RequestContext;
import org.mule.providers.file.FileConnector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.FileUtils;

public class AutoDeleteOnFileDispatcherReceiverTestCase
extends AbstractMuleTestCase {
    private File validMessage;
    private String tempDirName = "input";
    File tempDir;
    UMOConnector connector;

    public void testAutoDeleteFalseOnDispatcher() throws Exception {
        ((FileConnector)this.connector).setAutoDelete(false);
        UMOEvent event = AutoDeleteOnFileDispatcherReceiverTestCase.getTestEvent((Object)"TestData");
        event = RequestContext.setEvent((UMOEvent)event);
        UMOMessage message = RequestContext.getEventContext().receiveEvent(this.getTestEndpointURI() + "/" + this.tempDirName + "?connector=FileConnector", 50000L);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)message.getPayload());
        File[] files = this.tempDir.listFiles();
        AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((files.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < files.length; ++i) {
            AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((boolean)files[i].getName().equals(message.getProperty("originalFilename")));
            files[i].delete();
        }
    }

    public void testAutoDeleteTrueOnDispatcher() throws Exception {
        ((FileConnector)this.connector).setAutoDelete(true);
        UMOEvent event = AutoDeleteOnFileDispatcherReceiverTestCase.getTestEvent((Object)"TestData");
        event = RequestContext.setEvent((UMOEvent)event);
        UMOMessage message = RequestContext.getEventContext().receiveEvent(this.getTestEndpointURI() + "/" + this.tempDirName, 50000L);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)message.getPayload());
        File[] files = this.tempDir.listFiles();
        AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((files.length == 0 ? 1 : 0) != 0);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.tempDir = FileUtils.newFile((String)RegistryContext.getConfiguration().getWorkingDirectory(), (String)this.tempDirName);
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
        this.validMessage = File.createTempFile("hello", ".txt", this.tempDir);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)this.validMessage);
        this.connector = this.getConnector();
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteTree((File)FileUtils.newFile((String)AutoDeleteOnFileDispatcherReceiverTestCase.getTestConnector().getProtocol()));
        super.doTearDown();
    }

    public UMOConnector getConnector() throws Exception {
        FileConnector connector = new FileConnector();
        connector.setName("FileConnector");
        connector.setManagementContext(managementContext);
        managementContext.applyLifecycle((Object)connector);
        managementContext.getRegistry().registerConnector((UMOConnector)connector, managementContext);
        return connector;
    }

    public String getTestEndpointURI() {
        return "file://" + managementContext.getRegistry().getConfiguration().getWorkingDirectory();
    }
}

