/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.util.Arrays;
import org.mule.RegistryContext;
import org.mule.providers.file.FileContentsMessageAdapter;
import org.mule.tck.providers.AbstractMessageAdapterTestCase;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.FileUtils;

public class FileContentsMessageAdapterTestCase
extends AbstractMessageAdapterTestCase {
    private String validMessageContent = "Yabbadabbadooo!";
    private byte[] validMessage = this.validMessageContent.getBytes();
    private File messageFile;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        File dir = FileUtils.newFile((String)RegistryContext.getConfiguration().getWorkingDirectory(), (String)"tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.messageFile = File.createTempFile("simple", ".mule", dir);
        FileUtils.writeStringToFile((File)this.messageFile, (String)this.validMessageContent, null);
    }

    public Object getValidMessage() {
        return this.validMessage;
    }

    public UMOMessageAdapter createAdapter(Object payload) throws MessagingException {
        if (payload.equals(this.validMessage)) {
            return new FileContentsMessageAdapter((Object)this.messageFile);
        }
        return new FileContentsMessageAdapter(payload);
    }

    public void doTestMessageEqualsPayload(Object message, Object payload) throws Exception {
        if (message instanceof byte[] && payload instanceof byte[]) {
            FileContentsMessageAdapterTestCase.assertTrue((boolean)Arrays.equals((byte[])message, (byte[])payload));
        } else {
            FileContentsMessageAdapterTestCase.fail((String)"message and payload must both be byte[]");
        }
    }

    public void testMessageContentsProperlyLoaded() throws Exception {
        FileContentsMessageAdapter adapter = new FileContentsMessageAdapter((Object)this.messageFile);
        FileContentsMessageAdapterTestCase.assertTrue((boolean)this.messageFile.delete());
        this.doTestMessageEqualsPayload(this.validMessage, adapter.getPayload());
    }
}

