/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import org.mule.extras.client.MuleClient;
import org.mule.providers.file.AbstractFileFunctionalTestCase;
import org.mule.providers.file.FileConnector;
import org.mule.umo.UMOMessage;

public class FileFunctionalTestCase
extends AbstractFileFunctionalTestCase {
    public void testSend() throws Exception {
        File target = File.createTempFile("mule-file-test-", ".txt");
        target.deleteOnExit();
        FileConnector connector = (FileConnector)managementContext.getRegistry().lookupConnector("sendConnector");
        connector.setWriteToDirectory(target.getParent());
        this.logger.debug((Object)("Directory is " + connector.getWriteToDirectory()));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("TARGET_FILE", target.getName());
        this.logger.debug((Object)("File is " + props.get("TARGET_FILE")));
        MuleClient client = new MuleClient();
        client.dispatch("send", (Object)"Test file contents", props);
        this.waitForFileSystem();
        String result = new BufferedReader(new FileReader(target)).readLine();
        FileFunctionalTestCase.assertEquals((String)"Test file contents", (String)result);
    }

    public void testDirectRequest() throws Exception {
        File target = this.initForRequest();
        MuleClient client = new MuleClient();
        String url = this.fileToUrl(target) + "?connector=receiveConnector";
        this.logger.debug((Object)url);
        UMOMessage message = client.request(url, 100000L);
        this.checkReceivedMessage(message);
    }
}

